/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.firmwares;

import com.kontakt.sdk.android.cloud.api.executor.FileRequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.FirmwaresService;
import com.kontakt.sdk.android.cloud.exception.KontaktCloudException;
import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.common.FileData;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.IOException;
import okhttp3.ResponseBody;
import retrofit2.Call;

public class FirmwareFileFromUrlRequestExecutor
extends FileRequestExecutor {
    private final FirmwaresService firmwaresService;
    private final String url;

    public FirmwareFileFromUrlRequestExecutor(FirmwaresService firmwaresService, String url) {
        this.firmwaresService = firmwaresService;
        this.url = url;
    }

    @Override
    public FileData execute() throws IOException, KontaktCloudException {
        this.checkPreconditions();
        return super.execute();
    }

    @Override
    public void execute(CloudCallback<FileData> callback) {
        this.checkPreconditions();
        super.execute(callback);
    }

    private void checkPreconditions() {
        SDKPreconditions.checkState(this.url != null, "cannot get firmware - specify url");
    }

    @Override
    protected Call<ResponseBody> prepareCall() {
        return this.firmwaresService.getFirmwareFileFromUrl(this.url);
    }
}

