/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.devices;

import com.kontakt.sdk.android.cloud.api.executor.RequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.DevicesService;
import com.kontakt.sdk.android.cloud.exception.KontaktCloudException;
import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.cloud.util.StringUtils;
import com.kontakt.sdk.android.common.model.Config;
import com.kontakt.sdk.android.common.model.Device;
import com.kontakt.sdk.android.common.model.DeviceType;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import retrofit2.Call;

public class UpdateDeviceRequestExecutor
extends RequestExecutor<String> {
    private final DevicesService devicesService;
    private final String uniqueId;
    private DeviceType deviceType;
    private Device device;
    private boolean forceUpdate;

    public UpdateDeviceRequestExecutor(DevicesService devicesService, String uniqueId) {
        this.devicesService = devicesService;
        this.uniqueId = uniqueId;
        this.deviceType = DeviceType.BEACON;
    }

    public UpdateDeviceRequestExecutor with(Device device) {
        SDKPreconditions.checkNotNull(device, "device cannot be null");
        this.device = device;
        if (device.getDeviceType() != null) {
            this.deviceType = device.getDeviceType();
        }
        return this;
    }

    public UpdateDeviceRequestExecutor force(boolean force) {
        this.forceUpdate = force;
        return this;
    }

    @Override
    public String execute() throws IOException, KontaktCloudException {
        this.checkPreconditions();
        return (String)super.execute();
    }

    @Override
    public void execute(CloudCallback<String> callback) {
        this.checkPreconditions();
        super.execute(callback);
    }

    @Override
    protected Call<String> prepareCall() {
        return this.devicesService.updateDevice(this.params());
    }

    private void checkPreconditions() {
        SDKPreconditions.checkState(this.device != null, "cannot update device - specify device data to update");
    }

    @Override
    protected Map<String, String> params() {
        Config config;
        Map<String, String> metadata;
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uniqueId", this.uniqueId);
        params.put("deviceType", this.deviceType.name());
        if (this.device.getAlias() != null) {
            params.put("alias", this.device.getAlias());
        }
        if (this.device.getFirmware() != null) {
            params.put("firmware", this.device.getFirmware());
        }
        if (this.device.getLatitude() != null) {
            params.put("lat", this.device.getLatitude());
        }
        if (this.device.getLongitude() != null) {
            params.put("lng", this.device.getLongitude());
        }
        if (this.device.getTags() != null) {
            params.put("tags", StringUtils.join(this.device.getTags(), ","));
        }
        if ((metadata = this.device.getMetadata()) != null) {
            for (String key : metadata.keySet()) {
                String keyParam = "metadata." + key;
                String value = metadata.get(key);
                params.put(keyParam, value);
            }
        }
        if ((config = this.device.getConfig()) != null) {
            if (config.getProximity() != null) {
                params.put("proximity", config.getProximity().toString());
            }
            if (config.getMajor() != -1) {
                params.put("major", String.valueOf(config.getMajor()));
            }
            if (config.getMinor() != -1) {
                params.put("minor", String.valueOf(config.getMinor()));
            }
            if (config.getTxPower() != -1) {
                params.put("txPower", String.valueOf(config.getTxPower()));
            }
            if (config.getInterval() != -1) {
                params.put("interval", String.valueOf(config.getInterval()));
            }
            if (config.getName() != null) {
                params.put("name", config.getName());
            }
            if (config.getNamespace() != null) {
                params.put("namespace", config.getNamespace());
            }
            if (config.getInstanceId() != null) {
                params.put("instanceId", config.getInstanceId());
            }
            if (config.getUrl() != null) {
                params.put("url", config.getHexUrl());
            }
            if (config.getProfiles() != null && !config.getProfiles().isEmpty()) {
                params.put("profiles", StringUtils.join(config.getProfiles(), ","));
            }
            if (config.getRssi1m() != null && !config.getRssi1m().isEmpty()) {
                params.put("rssi1m", StringUtils.join(config.getRssi1m(), ","));
            }
            if (config.getRssi0m() != null && !config.getRssi0m().isEmpty()) {
                params.put("rssi0m", StringUtils.join(config.getRssi0m(), ","));
            }
        }
        if (this.forceUpdate) {
            params.put("force", String.valueOf(true));
        }
        return params;
    }
}

