/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.configs;

import com.kontakt.sdk.android.cloud.api.executor.PaginatedRequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.ConfigsService;
import com.kontakt.sdk.android.cloud.exception.KontaktCloudException;
import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.cloud.response.paginated.Configs;
import com.kontakt.sdk.android.cloud.util.StringUtils;
import com.kontakt.sdk.android.common.Order;
import com.kontakt.sdk.android.common.model.DeviceType;
import com.kontakt.sdk.android.common.model.OrderBy;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import retrofit2.Call;

public class ConfigsRequestExecutor
extends PaginatedRequestExecutor<Configs> {
    private final ConfigsService configsService;
    private DeviceType type;
    private DeviceProfile profile;
    private String[] uniqueIds;
    private boolean fetchPassword;

    public ConfigsRequestExecutor(ConfigsService configsService) {
        this.configsService = configsService;
    }

    public ConfigsRequestExecutor type(DeviceType type) {
        this.type = SDKPreconditions.checkNotNull(type, "type cannot be null");
        return this;
    }

    public ConfigsRequestExecutor profile(DeviceProfile profile) {
        this.profile = SDKPreconditions.checkNotNull(profile, "profile cannot be null");
        return this;
    }

    public ConfigsRequestExecutor withIds(String ... uniqueIds) {
        this.uniqueIds = SDKPreconditions.checkNotNull(uniqueIds, "IDs cannot be null");
        return this;
    }

    public ConfigsRequestExecutor withIds(List<String> uniqueIds) {
        SDKPreconditions.checkNotNull(uniqueIds, "IDs cannot be null");
        int size = uniqueIds.size();
        this.uniqueIds = uniqueIds.toArray(new String[size]);
        return this;
    }

    @Override
    public ConfigsRequestExecutor startIndex(int startIndex) {
        super.startIndex(startIndex);
        return this;
    }

    @Override
    public ConfigsRequestExecutor maxResult(int maxResult) {
        super.maxResult(maxResult);
        return this;
    }

    @Override
    public ConfigsRequestExecutor filter(String query) {
        super.filter(query);
        return this;
    }

    @Override
    public ConfigsRequestExecutor orderBy(OrderBy orderBy, Order order) {
        super.orderBy(orderBy, order);
        return this;
    }

    @Override
    public ConfigsRequestExecutor eTag(String eTag) {
        super.eTag(eTag);
        return this;
    }

    public ConfigsRequestExecutor alsoFetchPassword() {
        this.fetchPassword = true;
        return this;
    }

    @Override
    public Configs execute() throws IOException, KontaktCloudException {
        this.checkPreconditions();
        return (Configs)super.execute();
    }

    @Override
    public void execute(CloudCallback<Configs> callback) {
        this.checkPreconditions();
        super.execute(callback);
    }

    @Override
    protected Call<Configs> prepareCall() {
        Call<Configs> call = this.eTag != null ? this.configsService.getConfigs(this.params(), this.eTag) : this.configsService.getConfigs(this.params());
        return call;
    }

    private void checkPreconditions() {
        SDKPreconditions.checkState(this.type != null, "Cannot get configs - specify device type");
    }

    @Override
    protected Map<String, String> params() {
        Map<String, String> params = super.params();
        if (this.type != null) {
            params.put("deviceType", this.type.name());
        }
        if (this.profile != null) {
            params.put("profile", this.profile.name());
        }
        if (this.uniqueIds != null && this.uniqueIds.length > 0) {
            params.put("uniqueId", StringUtils.join(this.uniqueIds, ","));
        }
        if (this.fetchPassword && this.type != null) {
            params.put("clientType", this.type.name());
        }
        return params;
    }
}

