/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.actions;

import com.kontakt.sdk.android.cloud.api.executor.RequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.ActionsService;
import com.kontakt.sdk.android.cloud.exception.KontaktCloudException;
import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.common.Proximity;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import retrofit2.Call;

abstract class UpdateActionRequestExecutor
extends RequestExecutor<String> {
    protected final ActionsService actionsService;
    protected final UUID id;
    protected Proximity proximity;

    public UpdateActionRequestExecutor(ActionsService actionsService, UUID id) {
        this.actionsService = actionsService;
        this.id = id;
    }

    public UpdateActionRequestExecutor withProximity(Proximity proximity) {
        SDKPreconditions.checkNotNull(proximity, "proximity cannot be null");
        this.proximity = proximity;
        return this;
    }

    @Override
    public String execute() throws IOException, KontaktCloudException {
        this.checkPreconditions();
        return (String)super.execute();
    }

    @Override
    public void execute(CloudCallback<String> callback) {
        this.checkPreconditions();
        super.execute(callback);
    }

    @Override
    protected Call<String> prepareCall() {
        return this.actionsService.updateAction(this.params());
    }

    protected abstract void checkPreconditions();

    @Override
    protected Map<String, String> params() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("actionId", this.id.toString());
        if (this.proximity != null) {
            params.put("proximity", this.proximity.name());
        }
        return params;
    }
}

