/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.spec;

import android.os.Parcel;
import android.os.Parcelable;

public class Acceleration
implements Parcelable {
    public static final Parcelable.Creator<Acceleration> CREATOR = new Parcelable.Creator<Acceleration>(){

        public Acceleration createFromParcel(Parcel source) {
            return new Acceleration(source);
        }

        public Acceleration[] newArray(int size) {
            return new Acceleration[size];
        }
    };
    private final int x;
    private final int y;
    private final int z;

    public Acceleration(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public Acceleration(byte[] accelerationData) {
        if (accelerationData == null || accelerationData.length != 3) {
            throw new IllegalArgumentException("Wrong acceleration data");
        }
        this.x = accelerationData[0];
        this.y = accelerationData[1];
        this.z = accelerationData[2];
    }

    protected Acceleration(Parcel in) {
        this.x = in.readInt();
        this.y = in.readInt();
        this.z = in.readInt();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Acceleration that = (Acceleration)o;
        if (this.x != that.x) {
            return false;
        }
        if (this.y != that.y) {
            return false;
        }
        return this.z == that.z;
    }

    public int hashCode() {
        int result = this.x;
        result = 31 * result + this.y;
        result = 31 * result + this.z;
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.x);
        dest.writeInt(this.y);
        dest.writeInt(this.z);
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public String toString() {
        return "Acceleration(x,y,z) = " + this.x + "," + this.y + "," + this.z;
    }
}

