/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.service;

import android.annotation.TargetApi;
import android.bluetooth.le.ScanSettings;
import com.kontakt.sdk.android.ble.cache.FutureShufflesCache;
import com.kontakt.sdk.android.ble.configuration.ForceScanConfiguration;
import com.kontakt.sdk.android.ble.configuration.ScanContext;
import com.kontakt.sdk.android.ble.monitoring.IEventCollector;
import com.kontakt.sdk.android.ble.service.ForceScanScheduler;
import com.kontakt.sdk.android.ble.service.MonitorCallback;
import com.kontakt.sdk.android.ble.service.MonitorCallbackL;
import com.kontakt.sdk.android.ble.service.Runners;
import com.kontakt.sdk.android.ble.service.RunnersL;
import com.kontakt.sdk.android.ble.service.ScanCompat;
import com.kontakt.sdk.android.ble.service.ScanConfiguration;
import com.kontakt.sdk.android.ble.service.ScanController;

@TargetApi(value=21)
final class ScanCompatL
extends ScanCompat {
    ScanCompatL() {
    }

    @Override
    public ScanConfiguration createScanConfiguration(ScanContext scanContext, FutureShufflesCache cache, IEventCollector eventCollector) {
        MonitorCallback callback = MonitorCallback.create(scanContext, cache, eventCollector);
        MonitorCallbackL callbackL = MonitorCallbackL.wrap(callback);
        final ScanSettings scanSettings = new ScanSettings.Builder().setScanMode(scanContext.getScanMode().getCode()).build();
        return new ScanCompat.AbstractScanConfigurationL(scanContext, callbackL){

            @Override
            public ScanSettings getScanSettings() {
                return scanSettings;
            }
        };
    }

    @Override
    public ScanController createScanController(ScanConfiguration configuration, ForceScanScheduler forceScanScheduler) {
        return new ScanController.Builder().setScanPeriod(configuration.getScanContext().getScanPeriod()).setScanActiveRunner(RunnersL.newRunner(Runners.RunnerType.MONITOR_ACTIVE_RUNNER, configuration)).setScanPassiveRunner(RunnersL.newRunner(Runners.RunnerType.MONITOR_PASSIVE_RUNNER, configuration)).setForceScanScheduler(forceScanScheduler).build();
    }

    @Override
    public ForceScanScheduler createForceScanScheduler(ScanConfiguration configuration) {
        ScanContext scanContext = configuration.getScanContext();
        if (scanContext.getForceScanConfiguration() == ForceScanConfiguration.DISABLED) {
            return ForceScanScheduler.DISABLED;
        }
        return new ForceScanScheduler(RunnersL.newRunner(Runners.RunnerType.FORCE_SCAN_RUNNER, configuration));
    }
}

