/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.security.property;

import com.kontakt.sdk.android.ble.security.property.AbstractProperty;
import com.kontakt.sdk.android.ble.security.property.PropertyID;
import com.kontakt.sdk.android.common.util.ArrayUtils;
import com.kontakt.sdk.android.common.util.ConversionUtils;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.UUID;

public class ByteArrayProperty
extends AbstractProperty<byte[]> {
    private static final int UUID_LENGTH = 16;
    private final byte[] value;

    public ByteArrayProperty(PropertyID id, byte[] value) {
        super(id);
        this.value = value;
    }

    public ByteArrayProperty(PropertyID id, UUID uuid) {
        super(id);
        this.value = ByteBuffer.allocate(16).putLong(uuid.getMostSignificantBits()).putLong(uuid.getLeastSignificantBits()).array();
    }

    public ByteArrayProperty(PropertyID id, String value) {
        super(id);
        this.value = ConversionUtils.hexStringToByteArray(value);
    }

    public ByteArrayProperty(PropertyID id, List<Integer> int8Array) {
        super(id);
        Byte[] bytes = new Byte[int8Array.size()];
        for (int i = 0; i < int8Array.size(); ++i) {
            Integer integer = int8Array.get(i);
            bytes[i] = integer.byteValue();
        }
        this.value = ArrayUtils.toPrimitive(bytes);
    }

    @Override
    public byte[] getBytes() {
        return this.value;
    }

    @Override
    public byte getSize() {
        return (byte)this.value.length;
    }

    @Override
    public byte[] getValue() {
        return this.value;
    }
}

