/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.rssi;

import com.kontakt.sdk.android.ble.rssi.LimitedMeanRssiCalculator;
import com.kontakt.sdk.android.ble.rssi.RssiCalculator;
import com.kontakt.sdk.android.common.util.SDKPreconditions;

public final class RssiCalculators {
    private static final int MAX_LOG_SIZE = 10;
    public static final RssiCalculator DEFAULT = new RssiCalculator(){

        @Override
        public int calculateRssi(int uniqueKey, int rssi) {
            return rssi;
        }

        @Override
        public void clear() {
        }

        @Override
        public void clear(int uniqueKey) {
        }
    };

    private RssiCalculators() {
    }

    public static LimitedMeanRssiCalculator newLimitedMeanRssiCalculator(int logLimit) {
        SDKPreconditions.checkArgument(logLimit > 0 && logLimit <= 10, "Rssi Mean limit should be a value within range (0, 10]");
        return new LimitedMeanRssiCalculator(logLimit);
    }
}

