/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.manager.service;

import android.annotation.TargetApi;
import android.content.Context;
import com.kontakt.sdk.android.ble.manager.service.ServiceConnector;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.util.PermissionsUtils;
import com.kontakt.sdk.android.common.util.SDKPreconditions;

public abstract class AbstractServiceConnector
implements ServiceConnector {
    private static final String[] PERMISSIONS = new String[]{"android.permission.BLUETOOTH", "android.permission.BLUETOOTH_ADMIN", "android.permission.INTERNET"};
    private static final String[] PERMISSIONS_MARSHMALLOW = new String[]{"android.permission.ACCESS_FINE_LOCATION", "android.permission.ACCESS_COARSE_LOCATION"};
    protected Context context;

    protected AbstractServiceConnector(Context context) {
        SDKPreconditions.checkState(context != null, "Applied context instance is null");
        this.context = context.getApplicationContext();
    }

    @Override
    public void disconnect() {
        Logger.d(this.getClass().getSimpleName() + " disconnected.");
    }

    @TargetApi(value=15)
    protected void checkPermissions() {
        PermissionsUtils.checkPermissions(this.context, PERMISSIONS);
        PermissionsUtils.checkAtLeastOneMarshmallowPermissionGranted(this.context, PERMISSIONS_MARSHMALLOW);
    }
}

