/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.filter.ibeacon;

import com.kontakt.sdk.android.ble.filter.ibeacon.IBeaconFilter;
import com.kontakt.sdk.android.common.profile.IBeaconDevice;
import com.kontakt.sdk.android.common.util.SDKPreconditions;

public final class IBeaconUniqueIdFilter
implements IBeaconFilter {
    private final String beaconUniqueId;

    public IBeaconUniqueIdFilter(String beaconUniqueId) {
        SDKPreconditions.checkNotNull(beaconUniqueId, "Beacon unique id is null");
        this.beaconUniqueId = beaconUniqueId;
    }

    @Override
    public boolean apply(IBeaconDevice target) {
        String uniqueId = target.getUniqueId();
        return uniqueId != null && this.beaconUniqueId.equals(uniqueId);
    }

    public String getBeaconUniqueId() {
        return this.beaconUniqueId;
    }
}

