/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery;

import com.kontakt.sdk.android.common.util.ConversionUtils;
import java.util.Arrays;

public final class ScanResponse {
    public static final ScanResponse UNKNOWN = new ScanResponse(null, -1, "-1", false, new byte[0]);
    public static final int TYPE_SERVICE_DATA = 22;
    public static final byte PAYLOAD_VERSION_1 = 1;
    public static final byte D00D_SERVICE_UUID_MSB = 13;
    public static final byte D00D_SERVICE_UUID_LSB = -48;
    public static final byte PDI_SERVICE_UUID_MSB = 106;
    public static final byte PDI_SERVICE_UUID_LSB = -2;
    public static final int KONTAKT_DEVICE_SCAN_RESPONSE_MIN_LENGTH = 9;
    public static final byte[] SCAN_RESPONSE_D00D_PREFIX = new byte[]{13, -48};
    public static final byte[] SCAN_RESPONSE_PDI_PREFIX = new byte[]{106, -2};
    private final String uniqueId;
    private final int batteryPercentagePower;
    private final String firmwareVersion;
    private final boolean shuffled;
    private final byte[] bytes;

    public static boolean isValidKontaktScanResponse(byte[] serviceData) {
        return serviceData.length >= 9 && ConversionUtils.doesArrayBeginWith(serviceData, SCAN_RESPONSE_D00D_PREFIX);
    }

    public static ScanResponse fromScanResponseBytes(byte[] scanResponse) {
        int batteryPercentagePower;
        String firmware;
        boolean isShuffled;
        if (scanResponse == null || !ScanResponse.isValidKontaktScanResponse(scanResponse)) {
            return UNKNOWN;
        }
        String uniqueId = null;
        byte payloadVersion = scanResponse[2];
        boolean bl = isShuffled = payloadVersion == 1;
        if (isShuffled) {
            firmware = ScanResponse.parseShuffledFirmwareVersion(scanResponse);
            batteryPercentagePower = ScanResponse.extractShuffledBatteryPercentagePower(scanResponse);
        } else {
            uniqueId = ScanResponse.parseUniqueId(scanResponse);
            firmware = ScanResponse.parseFirmwareVersion(scanResponse);
            batteryPercentagePower = ScanResponse.extractBatteryPercentagePower(scanResponse);
        }
        return new ScanResponse(uniqueId, batteryPercentagePower, firmware, isShuffled, scanResponse);
    }

    private ScanResponse(String uniqueId, int batteryPercentagePower, String firmwareVersion, boolean shuffled, byte[] bytes) {
        this.uniqueId = uniqueId;
        this.batteryPercentagePower = batteryPercentagePower;
        this.firmwareVersion = firmwareVersion;
        this.shuffled = shuffled;
        this.bytes = bytes;
    }

    public String getFirmwareVersion() {
        return this.firmwareVersion;
    }

    public int getBatteryPower() {
        return this.batteryPercentagePower;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public byte[] getBytes() {
        return this.bytes;
    }

    public boolean isShuffled() {
        return this.shuffled;
    }

    public boolean isUnknown() {
        return this.uniqueId == null && this.batteryPercentagePower == -1 && "-1".equalsIgnoreCase(this.firmwareVersion);
    }

    private static String parseShuffledFirmwareVersion(byte[] serviceData) {
        if (serviceData != null) {
            char firmwareVersionMajor = (char)(serviceData[23] & 0xFF);
            char firmwareVersionMinor = (char)(serviceData[24] & 0xFF);
            return String.format("%c.%c", Character.valueOf(firmwareVersionMajor), Character.valueOf(firmwareVersionMinor));
        }
        return "-1";
    }

    private static String parseFirmwareVersion(byte[] serviceData) {
        if (serviceData != null) {
            char firmwareVersionMajor = (char)(serviceData[6] & 0xFF);
            char firmwareVersionMinor = (char)(serviceData[7] & 0xFF);
            return String.format("%c.%c", Character.valueOf(firmwareVersionMajor), Character.valueOf(firmwareVersionMinor));
        }
        return "-1";
    }

    private static int extractBatteryPercentagePower(byte[] serviceData) {
        return serviceData != null ? serviceData[8] : -1;
    }

    private static int extractShuffledBatteryPercentagePower(byte[] serviceData) {
        return serviceData != null ? serviceData[25] : -1;
    }

    private static String parseUniqueId(byte[] serviceData) {
        return serviceData != null ? new String(Arrays.copyOfRange(serviceData, 2, 6)) : "";
    }

    public String toString() {
        return "Scan response: \nuniqueId: " + this.uniqueId + "\nbattery percentage: " + this.batteryPercentagePower + "\nfirmware version: " + this.firmwareVersion + "\nshuffled: " + this.shuffled;
    }
}

