/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.connection;

import android.content.Context;
import android.os.RemoteException;
import com.kontakt.sdk.android.ble.connection.GattController;
import com.kontakt.sdk.android.ble.connection.KontaktDeviceConnectionImpl;
import com.kontakt.sdk.android.ble.connection.SecureGattController;
import com.kontakt.sdk.android.ble.util.DeviceUtils;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;

final class GattControllerFactory {
    GattControllerFactory() {
    }

    static GattController createGattController(Context context, KontaktDeviceConnectionImpl kontaktDeviceConnection, RemoteBluetoothDevice remoteBluetoothDevice) throws RemoteException {
        if (DeviceUtils.isSecure(remoteBluetoothDevice)) {
            return new SecureGattController(kontaktDeviceConnection, context, remoteBluetoothDevice);
        }
        throw new IllegalStateException("Device you are trying to connect to has unsupported firmware version.");
    }

    static GattController createGattController(Context context, KontaktDeviceConnectionImpl connection, RemoteBluetoothDevice device, boolean shouldReadCharacteristics) throws RemoteException {
        if (DeviceUtils.isSecure(device)) {
            return new SecureGattController(connection, context, device, shouldReadCharacteristics);
        }
        throw new IllegalStateException("Device you are trying to connect to has unsupported firmware version.");
    }
}

