package com.kontakt.sdk.android.common.util;

import android.content.Context;
import android.os.Build;
import android.util.Log;

import com.kontakt.sdk.android.BuildConfig;
import com.kontakt.sdk.android.cloud.CloudConstants;

import java.io.IOException;
import java.util.Locale;

import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.ResponseBody;

import static com.kontakt.sdk.android.cloud.util.StringUtils.isAsciiPrintable;

public class ApiUtils {

    public static Interceptor commonHeadersInterceptor(final String apiKey, final int apiVersion){
        return new Interceptor() {
            @Override
            public Response intercept(Interceptor.Chain chain) throws IOException {
                final Request original = chain.request();
                final Request.Builder requestBuilder = original.newBuilder()
                        .header(CloudConstants.MainHeaders.ACCEPT, "application/vnd.com.kontakt+json;version=" + apiVersion)
                        .header(CloudConstants.MainHeaders.API_KEY, apiKey)
                        .method(original.method(), original.body());

                // Add Kontakt Agent Header if printable
                final String kontaktAgentHeader = kontaktAgentHeader();
                if (kontaktAgentHeader != null) {
                    requestBuilder.header(CloudConstants.MainHeaders.KONTAKT_AGENT, kontaktAgentHeader);
                }


                final Request request = requestBuilder.build();
                return chain.proceed(request);
            }
        };
    }

    public static Interceptor loggingInterceptor(){
        return new Interceptor() {
            @Override
            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request request = chain.request();

                Response response = chain.proceed(request);
                String rawReponseJson = response.body().string();
                String rawRequestJson = request.toString();

                Log.d(BuildConfig.APPLICATION_ID, String.format("raw JSON request is: %s %s", rawRequestJson, request.url()));
                Log.d(BuildConfig.APPLICATION_ID, String.format("raw JSON response is: %s", rawReponseJson));

                return response.newBuilder()
                        .body(ResponseBody.create(response.body().contentType(), rawReponseJson)).build();
            }
        };
    }

    private static String kontaktAgentHeader() {
        final String sdkVersion = BuildConfig.VERSION_NAME;
        final int systemVersion = Build.VERSION.SDK_INT;
        final String agentHeader = String.format(Locale.getDefault(), "sdk-%s-Android-%d", sdkVersion, systemVersion);

        if (!isAsciiPrintable(agentHeader)) {
            return null;
        }
        return agentHeader;
    }

}
