package com.kontakt.sdk.android.common.model;

/**
 * Enumeration of interleave packet type.
 */
public enum PacketType {

  IBEACON("IBEACON"),

  EDDYSTONE_UID("UID"),

  EDDYSTONE_URL("URL"),

  EDDYSTONE_TLM("TLM"),

  EDDYSTONE_EID("EID"),

  EDDYSTONE_ETLM("ETLM"),

  KONTAKT_TLM("KTLM"),

  BUTTON_IBEACON("BUTTON_IBEACON"),

  KONTAKT_LOCATION("KONTAKT_LOCATION"),

  TT_FRAME("TT_FRAME"),

  KONTAKT("KONTAKT_PROFILE");

  private final String shortName;

  PacketType(String shortName) {
    this.shortName = shortName;
  }

  public String getShortName() {
    return shortName;
  }

  public static PacketType fromShortName(String value) {
    for (PacketType packetType : PacketType.values()) {
      if (packetType.getShortName().equals(value)) {
        return packetType;
      }
    }
    throw new IllegalArgumentException("Can't create PacketType from given string");
  }
}
