package com.kontakt.sdk.android.common.model;

import android.os.Parcel;
import android.os.Parcelable;

import com.kontakt.sdk.android.ble.spec.Acceleration;
import com.kontakt.sdk.android.ble.spec.KontaktTelemetry;
import com.kontakt.sdk.android.common.profile.ISecureProfile;

public class FullTelemetryCollectEvent implements Parcelable {

    public final String sourceId;
    public final String trackingId;
    public final long timestamp;
    public final int batteryLevel;
    public final Acceleration acceleration;
    public final int accelerometerSensitivity;
    public final int timeSinceDoubleTap;
    public final int timeSinceTap;
    public final int timeSinceDoubleClick;
    public final int timeSinceClick;
    public final int movementCounter;
    public final int clickCounter;
    public final int secondButtonClickCounter;
    public final int humidity;
    public final int lightIntensity;
    public final int channel;
    public final int numberOfPeopleDetected;
    public final int secondsSincePeopleDetection;

    private FullTelemetryCollectEvent(String sourceId, String trackingId, KontaktTelemetry telemetry){
        this.sourceId = sourceId;
        this.trackingId = trackingId;
        this.timestamp = telemetry.getTimestamp();
        this.batteryLevel = telemetry.getBatteryLevel();
        this.acceleration = telemetry.getAcceleration();
        this.accelerometerSensitivity = telemetry.getSensitivity();
        this.timeSinceDoubleTap = telemetry.getLastDoubleTap();
        this.timeSinceTap = telemetry.getLastTap();
        this.timeSinceDoubleClick = telemetry.getLastDoubleClick();
        this.timeSinceClick = telemetry.getLastSingleClick();
        this.movementCounter = telemetry.getCurrentMovementId();
        this.clickCounter = telemetry.getSingleClickCount();
        this.secondButtonClickCounter = telemetry.getSingleClickCount2();
        this.humidity = telemetry.getHumidity();
        this.lightIntensity = telemetry.getLightSensor();
        this.channel = telemetry.getBleChannel();
        this.numberOfPeopleDetected = telemetry.getOccupancy();
        this.secondsSincePeopleDetection = telemetry.getOccupancyDetectionTime();
    }

    private FullTelemetryCollectEvent(Parcel in) {
        sourceId = in.readString();
        trackingId = in.readString();
        timestamp = in.readLong();
        batteryLevel = in.readInt();
        acceleration = in.readParcelable(Acceleration.class.getClassLoader());
        accelerometerSensitivity = in.readInt();
        timeSinceDoubleTap = in.readInt();
        timeSinceTap = in.readInt();
        timeSinceDoubleClick = in.readInt();
        timeSinceClick = in.readInt();
        movementCounter = in.readInt();
        clickCounter = in.readInt();
        secondButtonClickCounter = in.readInt();
        humidity = in.readInt();
        lightIntensity = in.readInt();
        channel = in.readInt();
        numberOfPeopleDetected = in.readInt();
        secondsSincePeopleDetection = in.readInt();
    }

    public static final Creator<FullTelemetryCollectEvent> CREATOR = new Creator<FullTelemetryCollectEvent>() {
        @Override
        public FullTelemetryCollectEvent createFromParcel(Parcel in) {
            return new FullTelemetryCollectEvent(in);
        }

        @Override
        public FullTelemetryCollectEvent[] newArray(int size) {
            return new FullTelemetryCollectEvent[size];
        }
    };

    public String eventId(){
        return trackingId + ":" + batteryLevel + ":" + movementCounter
                + ":" + clickCounter + ":" + secondButtonClickCounter
                + ":" + lightIntensity + ":" + channel + ":" + numberOfPeopleDetected + ":" + humidity; // most preferably include only fields that are not time-dependent (like timestamps)
    }

    public static FullTelemetryCollectEvent of(ISecureProfile profile, String androidId){
        return new FullTelemetryCollectEvent(
                androidId,
                profile.getMacAddress(),
                profile.getTelemetry()
        );
    }


    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(sourceId);
        dest.writeString(trackingId);
        dest.writeLong(timestamp);
        dest.writeInt(batteryLevel);
        dest.writeParcelable(acceleration, flags);
        dest.writeInt(accelerometerSensitivity);
        dest.writeInt(timeSinceDoubleTap);
        dest.writeInt(timeSinceTap);
        dest.writeInt(timeSinceDoubleClick);
        dest.writeInt(timeSinceClick);
        dest.writeInt(movementCounter);
        dest.writeInt(clickCounter);
        dest.writeInt(secondButtonClickCounter);
        dest.writeInt(humidity);
        dest.writeInt(lightIntensity);
        dest.writeInt(channel);
        dest.writeInt(numberOfPeopleDetected);
        dest.writeInt(secondsSincePeopleDetection);
    }
}
