package com.kontakt.sdk.android.common.model;

import android.os.Parcel;
import android.os.Parcelable;

import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;

public class BasicTelemetryCollectEvent implements Parcelable {

    private long timestamp;
    private String sourceId;
    private String trackingId;
    private int batteryLevel;

    private BasicTelemetryCollectEvent(long timestamp, String sourceId, String trackingId, int batteryLevel){
        this.timestamp = timestamp;
        this.sourceId = sourceId;
        this.trackingId = trackingId;
        this.batteryLevel = batteryLevel;
    }

    private BasicTelemetryCollectEvent(Parcel in) {
        timestamp = in.readLong();
        sourceId = in.readString();
        trackingId = in.readString();
        batteryLevel = in.readInt();
    }

    public static final Creator<BasicTelemetryCollectEvent> CREATOR = new Creator<BasicTelemetryCollectEvent>() {
        @Override
        public BasicTelemetryCollectEvent createFromParcel(Parcel in) {
            return new BasicTelemetryCollectEvent(in);
        }

        @Override
        public BasicTelemetryCollectEvent[] newArray(int size) {
            return new BasicTelemetryCollectEvent[size];
        }
    };

    public static BasicTelemetryCollectEvent of(RemoteBluetoothDevice device, String androidId) {
        return new BasicTelemetryCollectEvent(
            device.getTimestamp(),
            androidId,
            device.getAddress(),
            device.getBatteryPower()
        );
    }

    @Override
    public int describeContents() {
        return 0;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(timestamp);
        dest.writeString(sourceId);
        dest.writeString(trackingId);
        dest.writeInt(batteryLevel);
    }

    public int getBatteryLevel() {
        return batteryLevel;
    }

    public long getTimestamp() {
        return timestamp;
    }

    public String getSourceId() {
        return sourceId;
    }

    public String getTrackingId() {
        return trackingId;
    }
}
