package com.kontakt.sdk.android.cloud.util;

import android.text.TextUtils;

import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.List;
import java.util.regex.Pattern;

/**
 * String utility methods.
 */
public final class StringUtils {

  private static final int LOWEST_ASCII_PRINTABLE_VALUE = 32;
  private static final int HIGHEST_ASCII_PRINTABLE_VALUE = 127;

  private StringUtils() {
    // prevent from creation
  }

  /**
   * Joins the elements of the provided list into a single String containing the provided elements.
   *
   * @param elements the list of values to join together.
   * @param separator the separator value to use.
   * @return the joined String.
   */
  public static String join(List<?> elements, String separator) {
    SDKPreconditions.checkNotNull(elements, "elements cannot be null");
    SDKPreconditions.checkNotNull(separator, "separator cannot be null");
    StringBuilder result = new StringBuilder();
    int size = elements.size();
    for (int i = 0; i < size; i++) {
      Object element = elements.get(i);
      result.append(element.toString());
      if (i < size - 1) {
        result.append(separator);
      }
    }
    return result.toString();
  }

  /**
   * Joins the elements of the provided array into a single String containing the provided elements.
   *
   * @param elements the array of values to join together.
   * @param separator the separator value to use.
   * @return the joined String.
   */
  public static String join(Object[] elements, String separator) {
    SDKPreconditions.checkNotNull(elements, "elements cannot be null");
    SDKPreconditions.checkNotNull(separator, "separator cannot be null");
    StringBuilder result = new StringBuilder();
    int size = elements.length;
    for (int i = 0; i < size; i++) {
      Object element = elements[i];
      result.append(element.toString());
      if (i < size - 1) {
        result.append(separator);
      }
    }
    return result.toString();
  }

  public static boolean isAsciiPrintable(String string) {
    if (string == null) {
      return false;
    }
    int length = string.length();
    for (int i = 0; i < length; i++) {
      if (!isAsciiPrintable(string.charAt(i))) {
        return false;
      }
    }
    return true;
  }

  private static boolean isAsciiPrintable(char character) {
    return character >= LOWEST_ASCII_PRINTABLE_VALUE && character < HIGHEST_ASCII_PRINTABLE_VALUE;
  }

  public static String addPrefixIfNotContainsSkipSequence(String s, String prefix, String skipSequence){

    String finalPrefix =
        TextUtils.isEmpty(skipSequence) || !s.startsWith(skipSequence)
                ? prefix
                : "" ;

    String unprefixedInput =
        !TextUtils.isEmpty(skipSequence) && s.startsWith(skipSequence)
                ? s.replaceFirst(Pattern.quote(skipSequence), "")
                : s;

    return finalPrefix + unprefixedInput;
  }

}
