package com.kontakt.sdk.android.cloud.serialize;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.kontakt.sdk.android.common.model.Coordinates;
import com.kontakt.sdk.android.common.model.GeoCoordinates;
import com.kontakt.sdk.android.common.model.LocationCoordinates;
import com.kontakt.sdk.android.common.model.PlaceCoordinates;
import java.lang.reflect.Type;

public class CoordinatesDeserializer implements JsonDeserializer<Coordinates> {

  @Override
  public Coordinates deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
    if (json.isJsonNull()) {
      return null;
    }

    final String[] splitted = json.getAsString().split(",");

    if (splitted.length == 4) {
      // parse geo coordinates
      final String[] coords1 = splitted[0].split(":");
      final String[] coords2 = splitted[1].split(":");
      final String[] coords3 = splitted[2].split(":");
      final String[] coords4 = splitted[3].split(":");

      return new GeoCoordinates(
          Double.valueOf(coords1[0]), Double.valueOf(coords1[1]),
          Double.valueOf(coords2[0]), Double.valueOf(coords2[1]),
          Double.valueOf(coords3[0]), Double.valueOf(coords3[1]),
          Double.valueOf(coords4[0]), Double.valueOf(coords4[1])
      );
    }

    if (splitted.length == 2) {
      // parse place coordinates
      final String[] xCoords = splitted[0].split(":");
      final String[] yCoords = splitted[1].split(":");

      return new PlaceCoordinates(Double.valueOf(xCoords[0]), Double.valueOf(xCoords[1]),
          Double.valueOf(yCoords[0]), Double.valueOf(yCoords[1]));
    }

    if (splitted.length == 1) {
      // parse location coordinates
      final String[] coords = splitted[0].split(":");

      return new LocationCoordinates(Double.valueOf(coords[0]), Double.valueOf(coords[1]), Double.valueOf(coords[2]));
    }

    return null;
  }
}
