package com.kontakt.sdk.android.cloud.response.paginated;

import com.google.gson.annotations.SerializedName;
import com.kontakt.sdk.android.common.model.Activity;

import java.util.List;

/**
 * Triggers API response representation composed of activities list and search meta data.
 */
public class Activities extends PaginatedResponse<List<Activity>> {

  @SerializedName("activities") protected List<Activity> activities;

  /**
   * Returns the activity list.
   *
   * @return the activity list.
   */
  @Override
  public List<Activity> getContent() {
    return activities;
  }
}
