package com.kontakt.sdk.android.cloud.adapter;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.kontakt.sdk.android.ble.spec.Acceleration;
import com.kontakt.sdk.android.ble.spec.KontaktTelemetry;
import com.kontakt.sdk.android.common.model.FullTelemetryCollectEvent;

import java.io.IOException;

import static com.kontakt.sdk.android.cloud.util.DateUtil.timestampInSecondsToString;

public class FullTelemetryCollectEventTypeAdapter extends BaseTypeAdapter<FullTelemetryCollectEvent> {

    @Override
    public void write(JsonWriter out, FullTelemetryCollectEvent value) throws IOException {
        KontaktTelemetry defaultTelemetry = new KontaktTelemetry.Builder().build();
        out.beginObject();
        writeString(out, "trackingId", value.trackingId);
        writeString(out, "sourceId", value.sourceId);
        writeString(out, "timeStamp", timestampInSecondsToString(value.timestamp));
        maybeWriteInteger(out, "batteryLevel", value.batteryLevel, defaultTelemetry.getBatteryLevel());
        maybeWriteAccelerometer(out, value.acceleration);
        maybeWriteInteger(out, "accelerometerSensitivity", value.accelerometerSensitivity, defaultTelemetry.getSensitivity());
        maybeWriteInteger(out, "timeSinceDoubleTap", value.timeSinceDoubleTap, defaultTelemetry.getLastDoubleTap());
        maybeWriteInteger(out, "timeSinceTap", value.timeSinceTap, defaultTelemetry.getLastTap());
        maybeWriteInteger(out, "timeSinceDoubleClick", value.timeSinceDoubleClick, defaultTelemetry.getLastDoubleClick());
        maybeWriteInteger(out, "timeSinceClick", value.timeSinceClick, defaultTelemetry.getLastSingleClick());
        maybeWriteInteger(out, "movementCounter", value.movementCounter, defaultTelemetry.getCurrentMovementId());
        maybeWriteInteger(out, "clickCounter", value.clickCounter, defaultTelemetry.getSingleClickCount());
        maybeWriteInteger(out, "secondButtonClickCounter", value.secondButtonClickCounter, defaultTelemetry.getSingleClickCount2());
        maybeWriteInteger(out, "lightIntensity", value.lightIntensity, defaultTelemetry.getLightSensor());
        maybeWriteInteger(out, "humidity", value.humidity, defaultTelemetry.getHumidity());
        maybeWriteInteger(out, "channel", value.channel, defaultTelemetry.getBleChannel());
        maybeWriteInteger(out, "numberOfPeopleDetected", value.numberOfPeopleDetected, defaultTelemetry.getOccupancy());
        maybeWriteInteger(out, "secondsSincePeopleDetection", value.secondsSincePeopleDetection, defaultTelemetry.getOccupancyDetectionTime());
        out.endObject();
    }

    private void maybeWriteAccelerometer(JsonWriter out, Acceleration acceleration) throws IOException {
        if(acceleration == null) return;
        writeInteger(out, "accelerometerX", acceleration.getX());
        writeInteger(out, "accelerometerY", acceleration.getY());
        writeInteger(out, "accelerometerZ", acceleration.getZ());
    }

    private void maybeWriteInteger(JsonWriter out, String name, int value, int defaultValue) throws IOException {
        if(value != defaultValue){
            writeInteger(out, name, value);
        }
    }

    @Override
    public FullTelemetryCollectEvent read(JsonReader in) {
        return null; //todo implement if necessary
    }
}
