package com.kontakt.sdk.android.cloud.adapter;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.kontakt.sdk.android.common.model.BasicTelemetryCollectEvent;

import java.io.IOException;

import static com.kontakt.sdk.android.cloud.util.DateUtil.timestampInSecondsToString;

public class BasicTelemetryCollectEventTypeAdapter extends BaseTypeAdapter<BasicTelemetryCollectEvent>{

    @Override
    public void write(JsonWriter out, BasicTelemetryCollectEvent value) throws IOException {
        out.beginObject();
        writeString(out, "trackingId", value.getTrackingId());
        writeString(out, "sourceId", value.getSourceId());
        writeInteger(out, "batteryLevel", value.getBatteryLevel());
        writeString(out, "timeStamp", timestampInSecondsToString(value.getTimestamp()));
        out.endObject();
    }

    @Override
    public BasicTelemetryCollectEvent read(JsonReader in) {
        return null; //todo implement if necessary
    }

}
