package com.kontakt.sdk.android.ble.service;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.PendingIntent;
import android.bluetooth.BluetoothAdapter;
import android.bluetooth.le.BluetoothLeScanner;
import android.content.Context;
import android.content.Intent;
import android.os.Build;

import com.kontakt.sdk.android.ble.discovery.ScanErrors;
import com.kontakt.sdk.android.common.log.Logger;

class ScannerUtil {

    private static final String TAG = ScannerUtil.class.getSimpleName();
    static final String REQUEST_CODE = "requestCode";

    @SuppressLint("MissingPermission")
    @TargetApi(Build.VERSION_CODES.LOLLIPOP)
    static BluetoothLeScanner getScanner(final MonitorCallbackL monitorCallback) {
        // Create Bluetooth LE Scanner and inform about eventual errors
        final BluetoothAdapter adapter = BluetoothAdapter.getDefaultAdapter();
        if (adapter != null) {
            final BluetoothLeScanner bluetoothLeScanner = adapter.getBluetoothLeScanner();
            if (bluetoothLeScanner == null) {
                if (adapter.isEnabled()) {
                    Logger.e(TAG + " SCAN FAILED: INTERNAL ERROR");
                    logToCallback(ScanErrors.SCAN_FAILED_INTERNAL_ERROR, monitorCallback);
                } else {
                    Logger.e(TAG + " SCAN FAILED: BLE ADAPTER DISABLED");
                    logToCallback(ScanErrors.SCAN_FAILED_BLUETOOTH_ADAPTER_DISABLED, monitorCallback);
                }
            }
            return bluetoothLeScanner;
        } else {
            Logger.e(TAG + " SCAN UNSUPPORTED: scanner null");
            logToCallback(ScanErrors.SCAN_FAILED_FEATURE_UNSUPPORTED, monitorCallback);
        }
        return null;
    }

    private static void logToCallback(int errorCode, final MonitorCallbackL monitorCallback){
        try {
            monitorCallback.onScanFailed(errorCode);
        } catch(NullPointerException e){
            Logger.w(TAG + "Tried to log scanner error code " + errorCode +  " to callback, but it was null");
        }
    }


    static PendingIntent getBroadcastPendingIntent(Context context, int requestCode){

        Intent intent = new Intent(context, BackgroundScanBroadcastReceiver.class);
        intent.putExtra(REQUEST_CODE, requestCode);
        intent.setAction("com.kontakt.sdk.android.ble.service.ACTION_FOUND");

        return PendingIntent.getBroadcast(context, requestCode, intent, PendingIntent.FLAG_UPDATE_CURRENT);
    }


    static int getReceiverCodeRequest(MonitorCallbackL callbackL){
        try {
            return callbackL.hashCode();
        } catch (NullPointerException e){
            return -1;
        }
    }
}