package com.kontakt.sdk.android.ble.service;

import android.annotation.TargetApi;
import android.bluetooth.le.ScanFilter;
import android.bluetooth.le.ScanSettings;
import android.content.Context;
import android.os.Build;

import com.kontakt.sdk.android.ble.cache.FutureShufflesCache;
import com.kontakt.sdk.android.ble.configuration.ForceScanConfiguration;
import com.kontakt.sdk.android.ble.configuration.KontaktScanFilter;
import com.kontakt.sdk.android.ble.configuration.ScanContext;
import com.kontakt.sdk.android.ble.monitoring.IEventCollector;

import java.util.ArrayList;
import java.util.List;

@TargetApi(Build.VERSION_CODES.LOLLIPOP)
final class ScanCompatL extends ScanCompat {

  public ScanConfiguration createScanConfiguration(final Context context, ScanContext scanContext, FutureShufflesCache cache, IEventCollector eventCollector) {
    final BleScanCallback callback = MonitorCallback.create(scanContext, cache, eventCollector);
    final BleScanCallback callbackL = MonitorCallbackL.wrap(callback);
    final ScanSettings scanSettings = new ScanSettings.Builder()
        .setScanMode(scanContext.getScanMode().getCode())
        .build();

    final List<ScanFilter> scanFilters = getScanFilters(scanContext.getKontaktScanFilters());
    return new AbstractScanConfigurationL(scanContext, callbackL) {
      @Override
      public ScanSettings getScanSettings() {
        return scanSettings;
      }

      @Override
      public List<ScanFilter> getScanFilterList() {
        return scanFilters;
      }

      @Override
      public Context getContext() {
        return context;
      }
    };
  }

  private List<ScanFilter> getScanFilters(List<KontaktScanFilter> kontaktScanFilters){
    ArrayList<ScanFilter> scanFilters = new ArrayList<>();
    for(KontaktScanFilter kontaktScanFilter: kontaktScanFilters){

      ScanFilter.Builder builder = new ScanFilter.Builder();
      for(KontaktScanFilter.FilterType filterType: kontaktScanFilter.getFilterTypes()){
        switch(filterType){
          case DEVICE_NAME:
            builder.setDeviceName(kontaktScanFilter.getDeviceName());
            break;
          case DEVICE_ADDRESS:
            builder.setDeviceAddress(kontaktScanFilter.getDeviceAddress());
            break;
          case SERVICE_DATA:
            builder.setServiceData(kontaktScanFilter.getServiceDataUuid(), kontaktScanFilter.getServiceData(), kontaktScanFilter.getServiceDataMask());
            break;
          case MANUFACTURER_DATA:
            builder.setManufacturerData(kontaktScanFilter.getManufacturerId(), kontaktScanFilter.getManufacturerData(), kontaktScanFilter.getManufacturerDataMask());
            break;
          case SERVICE_UUID:
            builder.setServiceUuid(kontaktScanFilter.getServiceUuid(), kontaktScanFilter.getServiceUuidMask());
            break;
        }
      }

      scanFilters.add(builder.build());
    }
    return scanFilters;
  }

  public ScanController createScanController(ScanConfiguration configuration, ForceScanScheduler forceScanScheduler) {
    return new ScanController.Builder().setScanPeriod(configuration.getScanContext().getScanPeriod())
        .setScanActiveRunner(RunnersL.newRunner(Runners.RunnerType.MONITOR_ACTIVE_RUNNER, configuration))
        .setScanPassiveRunner(RunnersL.newRunner(Runners.RunnerType.MONITOR_PASSIVE_RUNNER, configuration))
        .setForceScanScheduler(forceScanScheduler)
        .build();
  }

  public ForceScanScheduler createForceScanScheduler(final ScanConfiguration configuration) {
    final ScanContext scanContext = configuration.getScanContext();
    if (scanContext.getForceScanConfiguration() == ForceScanConfiguration.DISABLED) {
      return ForceScanScheduler.DISABLED;
    }
    return new ForceScanScheduler(RunnersL.newRunner(Runners.RunnerType.FORCE_SCAN_RUNNER, configuration));
  }

}
