package com.kontakt.sdk.android.ble.service;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.bluetooth.le.BluetoothLeScanner;
import android.bluetooth.le.ScanResult;
import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;

import com.kontakt.sdk.android.common.log.Logger;

import java.util.ArrayList;
import java.util.concurrent.CopyOnWriteArraySet;

import static com.kontakt.sdk.android.ble.service.ScannerUtil.REQUEST_CODE;
import static com.kontakt.sdk.android.ble.service.ScannerUtil.getBroadcastPendingIntent;
import static com.kontakt.sdk.android.ble.service.ScannerUtil.getReceiverCodeRequest;
import static com.kontakt.sdk.android.ble.service.ScannerUtil.getScanner;

public class BackgroundScanBroadcastReceiver extends BroadcastReceiver {

    private static final String TAG = BackgroundScanBroadcastReceiver.class.getSimpleName();

    private static MonitorCallbackL monitorCallback;
    private static CopyOnWriteArraySet<Integer> cancelledCallbacks = new CopyOnWriteArraySet<>();

    public BackgroundScanBroadcastReceiver(){

    }

    @SuppressLint("MissingPermission")
    @TargetApi(Build.VERSION_CODES.O)
    @Override
    public void onReceive(Context context, Intent intent) {
        Logger.d("RECEIVED BROADCAST: " + intent.getAction() + " MonitorCallback: " + monitorCallback);
        int bleCallbackType = intent.getIntExtra(BluetoothLeScanner.EXTRA_CALLBACK_TYPE, -1);
        if (bleCallbackType != -1) {
            Logger.d("Passive background scan callback type: " + bleCallbackType);
            ArrayList<ScanResult> scanResults = intent.getParcelableArrayListExtra(
                    BluetoothLeScanner.EXTRA_LIST_SCAN_RESULT);
            try {
                stopScanIfCancelled(context, intent);
                monitorCallback.onBatchScanResults(scanResults);
            } catch(NullPointerException e){
                Logger.w("Null monitor callback");
            }
        }
    }

    @SuppressLint("MissingPermission")
    @TargetApi(Build.VERSION_CODES.O)
    private void stopScanIfCancelled(Context context, Intent intent){
        try{
            Bundle extras = intent.getExtras();
            if(extras == null) return;
            int requestCode = extras.getInt(REQUEST_CODE);
            if(!cancelledCallbacks.contains(requestCode) || getReceiverCodeRequest(monitorCallback) == requestCode) return;

            Logger.w(TAG + " Intent's request code was cancelled and scanner works, stopping scanner for request code: " + requestCode);
            BluetoothLeScanner scanner = getScanner(null);
            if(scanner != null){
                scanner.stopScan(getBroadcastPendingIntent(context, requestCode));
            }

        } catch (Exception e){
            Logger.e(TAG + " Tried to stop BT scanner from Background Scan Broadcast Receiver");
            e.printStackTrace();
        }
    }

    public static void setMonitorCallbackL(MonitorCallbackL monitorCallback, int requestCode){
        Logger.d(TAG + " Setting monitor callback to " + monitorCallback);
        BackgroundScanBroadcastReceiver.monitorCallback = monitorCallback;
        if(monitorCallback == null){
            cancelledCallbacks.add(requestCode);
        }
    }
}