package com.kontakt.sdk.android.ble.security.property;

import java.nio.ByteBuffer;
import java.util.Arrays;

public abstract class AbstractProperty<T> {

  private static final int PID_LENGTH_IN_BYTES = 2;
  private static final int VALUE_LENGTH_IN_BYTES = 1;

  private final PropertyID propertyID;

  protected AbstractProperty(PropertyID propertyID) {
    this.propertyID = propertyID;
  }

  public PropertyID getPropertyID() {
    return propertyID;
  }

  public byte[] getData() {
    byte[] value = getBytes();
    ByteBuffer buf = ByteBuffer.allocate(value.length + PID_LENGTH_IN_BYTES + VALUE_LENGTH_IN_BYTES);
    buf.put((byte) (value.length + PID_LENGTH_IN_BYTES));
    buf.putShort(Short.reverseBytes(propertyID.getValue()));
    buf.put(value);
    return buf.array();
  }

  public abstract byte[] getBytes();

  public abstract byte getSize();

  public abstract T getValue();

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    AbstractProperty<?> that = (AbstractProperty<?>) o;

    if (propertyID != null ? !propertyID.equals(that.propertyID) : that.propertyID != null) return false;
    return Arrays.equals(getBytes(), that.getBytes());
  }

  @Override
  public int hashCode() {
    int result = propertyID != null ? propertyID.hashCode() : 0;
    result = 31 * result + Arrays.hashCode(getBytes());
    return result;
  }

}
