package com.kontakt.sdk.android.ble.manager.listeners;

import com.kontakt.sdk.android.ble.discovery.BluetoothDeviceEvent;
import com.kontakt.sdk.android.ble.exception.ScanError;
import com.kontakt.sdk.android.ble.manager.internal.InternalProximityManager;

/**
 * Proximity listener provides callbacks for scan process performed by
 * ({@link InternalProximityManager}).
 * <br>
 * Please note that callback methods are invoked in a different thread than
 * the UI thread.
 */
public interface InternalProximityListener {

  /**
   * Called whenever specific event occurs.
   *
   * @param event the event
   */
  void onEvent(BluetoothDeviceEvent event);

  /**
   * Called when scan starts.
   */
  void onScanStart();

  /**
   * Called when scan stops.
   */
  void onScanStop();

  /**
   * Called when scan fails for some reason
   *
   * @param exception ScanError
   */
  void onScanError(ScanError exception);

  /**
   * Called when monitoring cycle starts;
   */
  void onMonitoringCycleStart();

  /**
   * Called when monitoring cycle ends;
   */
  void onMonitoringCycleStop();
}

