package com.kontakt.sdk.android.ble.discovery.secure_profile;

import com.kontakt.sdk.android.ble.device.SecureProfile;
import com.kontakt.sdk.android.ble.discovery.FramePayload;
import com.kontakt.sdk.android.ble.spec.KontaktTelemetry;

public class TelemetryPayloadResolver extends PayloadResolver {

  private static final byte PAYLOAD_IDENTIFIER = 0x03;

  private static final KontaktTLMResolver KONTAKT_TLM_RESOLVER = new KontaktTLMResolver();

  TelemetryPayloadResolver() {
    super(PAYLOAD_IDENTIFIER);
  }

  @Override
  public void resolve(FramePayload payload) {
    if (payload == null) {
      return;
    }

    // Get MAC address, name & service data
    final String macAddress = payload.getAddress();
    final String name = getName(payload);
    final byte[] serviceData = getServiceData(payload);

    // Parse telemetry
    final KontaktTelemetry telemetry = KONTAKT_TLM_RESOLVER.parse(serviceData);

    // Build secure profile object with telemetry data
    final SecureProfile secureProfile = new SecureProfile.Builder()
        .macAddress(macAddress)
        .name(name)
        .telemetry(telemetry)
        .shuffled(false)
        .build();

    // Do callback
    onPayloadResolved(secureProfile);
  }

}
