package com.kontakt.sdk.android.ble.connection;

import com.kontakt.sdk.android.cloud.KontaktCloud;
import com.kontakt.sdk.android.common.model.Config;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;

/**
 * Syncable Kontakt device connection combines {@link KontaktDeviceConnection} and {@link KontaktCloud} functionality.
 * The syncable connection allows for immediate pushes to both Bluetooth and its representation in Kontakt.io Web API.
 */
@SuppressWarnings("WeakerAccess")
public interface SyncableKontaktDeviceConnection {

  /**
   * Connects to beacon device
   *
   * @return true, if the connection attempt was initiated succesfully
   */
  boolean connectToDevice();

  /**
   * Returns true if Connection with Beacon is established.
   *
   * @return the boolean flag indicating whether connection is established.
   */
  boolean isConnectedToDevice();

  /**
   * Closes Beacon connection releases provided resources.
   */
  void close();

  /**
   * Gets devices that the connection is established with.
   *
   * @return the iBeacon device.
   */
  RemoteBluetoothDevice getDevice();

  /**
   * Returns true if Beacon was successfully authenticated.
   *
   * @return the boolean flag indicating whether beacon was authenticated.
   */
  boolean isDeviceAuthenticated();

  /**
   * Writes secure config and tries to sync with REST API
   *
   * @param secureConfig      the secureConfig
   * @param syncWriteListener {@link SyncableKontaktDeviceConnectionImpl.SyncWriteListener}
   */
  void applySecureConfig(Config secureConfig, SyncableKontaktDeviceConnectionImpl.SyncWriteListener syncWriteListener);
}
