/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;

public class TelemetryCollectEvent
implements Parcelable {
    private long timestamp;
    private String sourceId;
    private String trackingId;
    private int batteryLevel;
    public static final Parcelable.Creator<TelemetryCollectEvent> CREATOR = new Parcelable.Creator<TelemetryCollectEvent>(){

        public TelemetryCollectEvent createFromParcel(Parcel in) {
            return new TelemetryCollectEvent(in);
        }

        public TelemetryCollectEvent[] newArray(int size) {
            return new TelemetryCollectEvent[size];
        }
    };

    public TelemetryCollectEvent(long timestamp, String sourceId, String trackingId, int batteryLevel) {
        this.timestamp = timestamp;
        this.sourceId = sourceId;
        this.trackingId = trackingId;
        this.batteryLevel = batteryLevel;
    }

    protected TelemetryCollectEvent(Parcel in) {
        this.timestamp = in.readLong();
        this.sourceId = in.readString();
        this.trackingId = in.readString();
        this.batteryLevel = in.readInt();
    }

    public static TelemetryCollectEvent of(RemoteBluetoothDevice device, String androidId) {
        return new TelemetryCollectEvent(device.getTimestamp(), androidId, device.getAddress(), device.getBatteryPower());
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeLong(this.timestamp);
        dest.writeString(this.sourceId);
        dest.writeString(this.trackingId);
        dest.writeInt(this.batteryLevel);
    }

    public int getBatteryLevel() {
        return this.batteryLevel;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getSourceId() {
        return this.sourceId;
    }

    public String getTrackingId() {
        return this.trackingId;
    }
}

