/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

public enum Model {
    SMART_BEACON(1, "SB16-2"),
    SMART_BEACON_3(9, "SB18-3"),
    SMART_BEACON_3H(13, "SB18-3H"),
    USB_BEACON(3, "UB16-2"),
    CARD_BEACON(4, "CT16-2"),
    CARD_BEACON_2(11, "CT18-3"),
    GATEWAY(5, "GW16-2"),
    BEACON_PRO(6, "BP16-3"),
    PROBE(7, ""),
    TAG_BEACON(8, "S18-3"),
    COIN_TAG(12, "C18-3"),
    HEAVY_DUTY_BEACON(10, "HD18-3"),
    TOUGH_BEACON_2(14, "TB18-2"),
    BRACELET_TAG(15, "BT18-3"),
    BRACELET_TAG_2(17, "BT19-4"),
    UNIVERSAL_TAG(16, "UT19-1"),
    SENSOR_BEACON(-1, ""),
    CLOUD_BEACON(-1, "GW14-1"),
    EXTERNAL(-1, ""),
    TT_BEACON(19, "TT_BEACON"),
    MINEW_E5(20, "Minew E5"),
    MINEW_E7(21, "Minew E7"),
    MINEW_E8(22, "Minew E8"),
    MINEW_I3(23, "Minew I3"),
    MINEW_I7(24, "Minew I7"),
    MINEW_S1(25, "Minew S1"),
    LANYARD_TAG(26, "Lanyard Tag"),
    NANO_TAG(27, "Nano Tag"),
    PUCK_TAG(28, "Puck Tag"),
    PORTAL_LIGHT(29, "Portal Light"),
    SMART_BADGE(30, "Smart Badge"),
    PORTAL_BEAM(31, "Portal Beam"),
    NANO_SERIES(32, "Nano Series"),
    PARTNER_DEVICE(128, "Partner device"),
    UNKNOWN(-1, "");

    private final int code;
    private final String productName;

    private Model(int code, String productName) {
        this.code = code;
        this.productName = productName;
    }

    public int getCode() {
        return this.code;
    }

    public String getProductName() {
        return this.productName;
    }

    public static Model fromString(String modelString) {
        if (modelString != null) {
            for (Model model : Model.values()) {
                if (!modelString.equalsIgnoreCase(model.name())) continue;
                return model;
            }
        }
        return SMART_BEACON;
    }

    public static Model fromCode(int code) {
        if (code <= 0) {
            return UNKNOWN;
        }
        for (Model model : Model.values()) {
            if (model.getCode() != code) continue;
            return model;
        }
        return UNKNOWN;
    }
}

