/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.places;

import com.kontakt.sdk.android.cloud.api.executor.PaginatedRequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.PlacesService;
import com.kontakt.sdk.android.cloud.response.paginated.Places;
import com.kontakt.sdk.android.cloud.util.StringUtils;
import com.kontakt.sdk.android.common.Order;
import com.kontakt.sdk.android.common.model.OrderBy;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import retrofit2.Call;

public class PlacesRequestExecutor
extends PaginatedRequestExecutor<Places> {
    private final PlacesService placesService;
    private UUID[] placeIds;
    private UUID[] venueIds;

    public PlacesRequestExecutor(PlacesService placesService) {
        this.placesService = placesService;
    }

    public PlacesRequestExecutor withIds(UUID ... ids) {
        this.placeIds = SDKPreconditions.checkNotNull(ids, "Place IDs cannot be null");
        return this;
    }

    public PlacesRequestExecutor withIds(List<UUID> ids) {
        SDKPreconditions.checkNotNull(ids, "Place IDs cannot be null");
        int size = ids.size();
        this.placeIds = ids.toArray(new UUID[size]);
        return this;
    }

    public PlacesRequestExecutor fromVenues(UUID ... venueIds) {
        this.venueIds = SDKPreconditions.checkNotNull(venueIds, "Venue IDs cannot be null");
        return this;
    }

    public PlacesRequestExecutor fromVenues(List<UUID> venueIds) {
        SDKPreconditions.checkNotNull(venueIds, "Venue IDs cannot be null");
        int size = venueIds.size();
        this.venueIds = venueIds.toArray(new UUID[size]);
        return this;
    }

    @Override
    public PlacesRequestExecutor startIndex(int startIndex) {
        super.startIndex(startIndex);
        return this;
    }

    @Override
    public PlacesRequestExecutor maxResult(int maxResult) {
        super.maxResult(maxResult);
        return this;
    }

    @Override
    public PlacesRequestExecutor filter(String query) {
        super.filter(query);
        return this;
    }

    @Override
    public PlacesRequestExecutor orderBy(OrderBy orderBy, Order order) {
        super.orderBy(orderBy, order);
        return this;
    }

    @Override
    public PlacesRequestExecutor eTag(String eTag) {
        super.eTag(eTag);
        return this;
    }

    @Override
    protected Call<Places> prepareCall() {
        Call<Places> call = this.eTag != null ? this.placesService.getPlaces(this.params(), this.eTag) : this.placesService.getPlaces(this.params());
        return call;
    }

    @Override
    protected Map<String, String> params() {
        Map<String, String> params = super.params();
        if (this.placeIds != null && this.placeIds.length > 0) {
            params.put("placeId", StringUtils.join(this.placeIds, ","));
        }
        if (this.venueIds != null && this.venueIds.length > 0) {
            params.put("venueId", StringUtils.join(this.venueIds, ","));
        }
        return params;
    }
}

