/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.activities;

import com.kontakt.sdk.android.cloud.api.executor.RequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.ActivitiesService;
import com.kontakt.sdk.android.cloud.exception.KontaktCloudException;
import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.cloud.util.StringUtils;
import com.kontakt.sdk.android.common.model.Activity;
import com.kontakt.sdk.android.common.model.ActivityContext;
import com.kontakt.sdk.android.common.model.HttpMethod;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import retrofit2.Call;

public class CreateActivityRequestExecutor
extends RequestExecutor<Activity> {
    private final ActivitiesService activitiesService;
    private final Activity activity;

    public CreateActivityRequestExecutor(ActivitiesService activitiesService, Activity activity) {
        this.activitiesService = activitiesService;
        this.activity = activity;
    }

    @Override
    public Activity execute() throws IOException, KontaktCloudException {
        this.checkPreconditions();
        return (Activity)super.execute();
    }

    @Override
    public void execute(CloudCallback<Activity> callback) {
        this.checkPreconditions();
        super.execute(callback);
    }

    @Override
    protected Call<Activity> prepareCall() {
        return this.activitiesService.create(this.params());
    }

    private void checkPreconditions() {
        SDKPreconditions.checkState(this.activity.getName() != null, "Cannot create activity - specify name");
        SDKPreconditions.checkState(this.activity.getType() != null, "Cannot create activity - specify type");
        ActivityContext context = this.activity.getContext();
        SDKPreconditions.checkState(context != null, "Cannot create activity - specify context");
        SDKPreconditions.checkState(context.getHttpMethod() != null, "Cannot create activity - specify HTTP method");
        SDKPreconditions.checkState(context.getUrl() != null, "Cannot create activity - specify url");
        if (context.getHttpMethod() == HttpMethod.POST || context.getHttpMethod() == HttpMethod.PUT) {
            SDKPreconditions.checkState(context.getHeaders() != null, "Cannot create activity - specify content-type header for this HTTP method");
            SDKPreconditions.checkState(context.getHeaders().containsKey("content-type"), "Cannot create activity - specify content-type header for this HTTP method");
        }
    }

    @Override
    protected Map<String, String> params() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("name", this.activity.getName());
        params.put("type", this.activity.getType().name());
        params.put("context.url", this.activity.getContext().getUrl());
        params.put("context.httpMethod", this.activity.getContext().getHttpMethod().name());
        List<UUID> triggerIds = this.activity.getTriggerIds();
        if (triggerIds != null && !triggerIds.isEmpty()) {
            params.put("triggerId", StringUtils.join(triggerIds, ","));
        }
        Map<String, String> headers = this.activity.getContext().getHeaders();
        Map<String, String> parameters = this.activity.getContext().getParameters();
        if (headers != null) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                params.put("context.headers." + entry.getKey(), entry.getValue());
            }
        }
        if (parameters != null) {
            for (Map.Entry<String, String> entry : parameters.entrySet()) {
                params.put("context.params." + entry.getKey(), entry.getValue());
            }
        }
        return params;
    }
}

