/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.actions;

import android.util.Base64;
import com.kontakt.sdk.android.cloud.api.executor.actions.UpdateActionRequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.ActionsService;
import com.kontakt.sdk.android.common.Proximity;
import com.kontakt.sdk.android.common.util.ConversionUtils;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;

public class UpdateContentActionRequestExecutor
extends UpdateActionRequestExecutor {
    private String encodedFile;

    public UpdateContentActionRequestExecutor(ActionsService actionsService, UUID id) {
        super(actionsService, id);
    }

    public UpdateContentActionRequestExecutor withMediaFile(File file) throws IOException {
        SDKPreconditions.checkNotNull(file, "file is null");
        SDKPreconditions.checkState(file.exists(), "file does not exist");
        byte[] bytes = ConversionUtils.convert(file);
        this.encodedFile = Base64.encodeToString((byte[])bytes, (int)0);
        return this;
    }

    @Override
    public UpdateContentActionRequestExecutor withProximity(Proximity proximity) {
        super.withProximity(proximity);
        return this;
    }

    @Override
    protected void checkPreconditions() {
        SDKPreconditions.checkState(this.encodedFile != null, "cannot update action - specify media file");
    }

    @Override
    protected Map<String, String> params() {
        Map<String, String> params = super.params();
        params.put("file", this.encodedFile);
        return params;
    }
}

