/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.adapter;

import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.kontakt.sdk.android.cloud.adapter.BaseTypeAdapter;
import com.kontakt.sdk.android.common.model.TelemetryCollectEvent;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class TelemetryCollectEventTypeAdapter
extends BaseTypeAdapter<TelemetryCollectEvent> {
    private static final String dateFormat = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";

    public void write(JsonWriter out, TelemetryCollectEvent value) throws IOException {
        out.beginObject();
        this.writeString(out, "trackingId", value.getTrackingId());
        this.writeString(out, "sourceId", value.getSourceId());
        this.writeInteger(out, "batteryLevel", value.getBatteryLevel());
        this.writeString(out, "timeStamp", this.timestampToString(value.getTimestamp()));
        out.endObject();
    }

    private String timestampToString(long timestamp) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat);
        return simpleDateFormat.format(new Date(timestamp));
    }

    public TelemetryCollectEvent read(JsonReader in) throws IOException {
        in.beginObject();
        String trackingId = in.nextString();
        String sourceId = in.nextString();
        int batteryLevel = in.nextInt();
        long timestamp = this.dateStringToTimestamp(in.nextString());
        in.endObject();
        return new TelemetryCollectEvent(timestamp, sourceId, trackingId, batteryLevel);
    }

    private long dateStringToTimestamp(String dateString) {
        try {
            return new SimpleDateFormat(dateFormat).parse(dateString).getTime();
        }
        catch (ParseException e) {
            e.printStackTrace();
            return 0L;
        }
    }
}

