/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.util;

import com.kontakt.sdk.android.common.model.Device;
import com.kontakt.sdk.android.common.model.FirmwareVersion;
import com.kontakt.sdk.android.common.model.Model;
import com.kontakt.sdk.android.common.profile.RemoteBluetoothDevice;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.EnumSet;

public final class DeviceUtils {
    private static final EnumSet<Model> SECURE_PROFILES = EnumSet.of(Model.GATEWAY, new Model[]{Model.BEACON_PRO, Model.PROBE, Model.TAG_BEACON, Model.SMART_BEACON_3, Model.SMART_BEACON_3H, Model.HEAVY_DUTY_BEACON, Model.CARD_BEACON_2, Model.TOUGH_BEACON_2, Model.BRACELET_TAG, Model.UNIVERSAL_TAG, Model.BRACELET_TAG_2, Model.TT_BEACON, Model.MINEW_E5, Model.MINEW_E7, Model.MINEW_E8, Model.MINEW_I3, Model.MINEW_I7, Model.MINEW_S1, Model.LANYARD_TAG, Model.NANO_TAG, Model.PUCK_TAG, Model.PORTAL_LIGHT, Model.SMART_BADGE, Model.PORTAL_BEAM, Model.NANO_SERIES, Model.PARTNER_DEVICE});
    private static final EnumSet<Model> GATEWAY_MODELS = EnumSet.of(Model.GATEWAY, Model.PORTAL_LIGHT);

    private DeviceUtils() {
    }

    public static boolean isSecure(Model model) {
        return SECURE_PROFILES.contains((Object)model);
    }

    public static boolean isSecure(Device device) {
        SDKPreconditions.checkNotNull(device, "Device cannot be null");
        return DeviceUtils.isSecure(device.getModel(), device.getFirmware());
    }

    public static boolean isSecure(RemoteBluetoothDevice device) {
        SDKPreconditions.checkNotNull(device, "Device cannot be null");
        return DeviceUtils.isSecure(device.getModel(), device.getFirmwareVersion());
    }

    public static boolean isSecure(Model model, String firmware) {
        SDKPreconditions.checkNotNull(model, "Model cannot be null");
        SDKPreconditions.checkNotNull(firmware, "Firmware version cannot be null");
        if (SECURE_PROFILES.contains((Object)model)) {
            return true;
        }
        FirmwareVersion minFirmwareVersion = new FirmwareVersion("4.0");
        FirmwareVersion deviceFirmwareVersion = new FirmwareVersion(firmware);
        return deviceFirmwareVersion.isGreaterOrEqualTo(minFirmwareVersion);
    }

    public static boolean hasRtcFeature(Device device) {
        SDKPreconditions.checkNotNull(device, "Device cannot be null");
        return DeviceUtils.hasRtcFeature(device.getModel(), device.getFirmware());
    }

    public static boolean hasRtcFeature(RemoteBluetoothDevice device) {
        SDKPreconditions.checkNotNull(device, "Device cannot be null");
        return DeviceUtils.hasRtcFeature(device.getModel(), device.getFirmwareVersion());
    }

    public static boolean hasButtonFeature(Model model) {
        return EnumSet.of(Model.CARD_BEACON_2, new Model[]{Model.TAG_BEACON, Model.BRACELET_TAG, Model.BRACELET_TAG_2, Model.UNIVERSAL_TAG, Model.MINEW_E5, Model.MINEW_E7, Model.MINEW_E8, Model.MINEW_I3, Model.MINEW_I7, Model.MINEW_S1, Model.PUCK_TAG}).contains((Object)model);
    }

    public static boolean hasRtcFeature(Model model, String firmware) {
        SDKPreconditions.checkNotNull(model, "Model cannot be null");
        SDKPreconditions.checkNotNull(firmware, "Firmware version cannot be null");
        if (EnumSet.of(Model.TAG_BEACON, new Model[]{Model.SMART_BEACON_3, Model.SMART_BEACON_3H, Model.HEAVY_DUTY_BEACON, Model.CARD_BEACON_2, Model.TOUGH_BEACON_2, Model.BRACELET_TAG, Model.UNIVERSAL_TAG, Model.BRACELET_TAG_2}).contains((Object)model)) {
            return true;
        }
        FirmwareVersion minFirmwareVersion = new FirmwareVersion("1.7");
        FirmwareVersion deviceFirmwareVersion = new FirmwareVersion(firmware);
        return model == Model.BEACON_PRO && deviceFirmwareVersion.isGreaterOrEqualTo(minFirmwareVersion);
    }

    public static boolean hasLightSensorFeature(Device device) {
        SDKPreconditions.checkNotNull(device, "Device cannot be null");
        return DeviceUtils.hasLightSensorFeature(device.getModel(), device.getFirmware());
    }

    public static boolean hasLightSensorFeature(RemoteBluetoothDevice device) {
        SDKPreconditions.checkNotNull(device, "Device cannot be null");
        return DeviceUtils.hasLightSensorFeature(device.getModel(), device.getFirmwareVersion());
    }

    public static boolean hasLightSensorFeature(Model model, String firmware) {
        SDKPreconditions.checkNotNull(model, "Model cannot be null");
        SDKPreconditions.checkNotNull(firmware, "Firmware version cannot be null");
        FirmwareVersion minFirmwareVersion = new FirmwareVersion("1.7");
        FirmwareVersion deviceFirmwareVersion = new FirmwareVersion(firmware);
        return model == Model.BEACON_PRO && deviceFirmwareVersion.isGreaterOrEqualTo(minFirmwareVersion);
    }

    public static boolean hasRtcAndLightSensorFeatures(Device device) {
        SDKPreconditions.checkNotNull(device, "Device cannot be null");
        return DeviceUtils.hasRtcAndLightSensorFeatures(device.getModel(), device.getFirmware());
    }

    public static boolean hasRtcAndLightSensorFeatures(RemoteBluetoothDevice device) {
        SDKPreconditions.checkNotNull(device, "Device cannot be null");
        return DeviceUtils.hasRtcAndLightSensorFeatures(device.getModel(), device.getFirmwareVersion());
    }

    public static boolean hasRtcAndLightSensorFeatures(Model model, String firmware) {
        SDKPreconditions.checkNotNull(model, "Model cannot be null");
        SDKPreconditions.checkNotNull(firmware, "Firmware version cannot be null");
        return DeviceUtils.hasRtcFeature(model, firmware) && DeviceUtils.hasLightSensorFeature(model, firmware);
    }

    public static boolean canTransmitKontaktTelemetry(Device device) {
        SDKPreconditions.checkNotNull(device, "Device cannot be null");
        return DeviceUtils.canTransmitKontaktTelemetry(device.getModel(), device.getFirmware());
    }

    public static boolean canTransmitKontaktTelemetry(Model model, String firmware) {
        SDKPreconditions.checkNotNull(model, "Model cannot be null");
        SDKPreconditions.checkNotNull(firmware, "Firmware version cannot be null");
        if (model != Model.BEACON_PRO && SECURE_PROFILES.contains((Object)model)) {
            return true;
        }
        FirmwareVersion minFirmwareVersion = new FirmwareVersion("1.10");
        FirmwareVersion deviceFirmwareVersion = new FirmwareVersion(firmware);
        return model == Model.BEACON_PRO && deviceFirmwareVersion.isGreaterOrEqualTo(minFirmwareVersion);
    }

    public static boolean canTransmitTTFrame(Model model) {
        return EnumSet.of(Model.TT_BEACON, new Model[]{Model.MINEW_E5, Model.MINEW_E7, Model.MINEW_E8, Model.MINEW_I3, Model.MINEW_I7, Model.MINEW_S1, Model.PUCK_TAG}).contains((Object)model);
    }

    public static boolean isInterleavingAvailable(Device device) {
        SDKPreconditions.checkNotNull(device, "Device cannot be null");
        return DeviceUtils.isInterleavingAvailable(device.getModel(), device.getFirmware());
    }

    public static boolean isInterleavingAvailable(Model model, String firmware) {
        SDKPreconditions.checkNotNull(model, "Model cannot be null");
        SDKPreconditions.checkNotNull(firmware, "Firmware version cannot be null");
        if (EnumSet.of(Model.BEACON_PRO, new Model[]{Model.TAG_BEACON, Model.SMART_BEACON_3, Model.SMART_BEACON_3H, Model.HEAVY_DUTY_BEACON, Model.CARD_BEACON_2, Model.TOUGH_BEACON_2, Model.BRACELET_TAG, Model.UNIVERSAL_TAG, Model.BRACELET_TAG_2, Model.MINEW_E5, Model.MINEW_E7, Model.MINEW_E8, Model.MINEW_I3, Model.MINEW_I7, Model.MINEW_S1, Model.PUCK_TAG, Model.NANO_TAG, Model.LANYARD_TAG}).contains((Object)model)) {
            return true;
        }
        FirmwareVersion minFirmwareVersion = new FirmwareVersion("4.1");
        FirmwareVersion deviceFirmwareVersion = new FirmwareVersion(firmware);
        return deviceFirmwareVersion.isGreaterOrEqualTo(minFirmwareVersion);
    }

    public static boolean isGateway(Model model) {
        return GATEWAY_MODELS.contains((Object)model);
    }
}

