/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.spec;

import android.annotation.TargetApi;
import android.bluetooth.BluetoothGattCharacteristic;
import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import com.kontakt.sdk.android.ble.spec.KontaktDeviceCharacteristic;
import com.kontakt.sdk.android.common.util.ConversionUtils;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.UUID;

@TargetApi(value=18)
public class BluetoothDeviceCharacteristic
extends BluetoothGattCharacteristic {
    private final String name;
    private final BluetoothGattCharacteristic characteristic;
    private KontaktDeviceCharacteristic kontaktDeviceCharacteristic;

    @TargetApi(value=18)
    public BluetoothDeviceCharacteristic(BluetoothGattCharacteristic characteristic) {
        super(characteristic.getUuid(), characteristic.getProperties(), characteristic.getPermissions());
        UUID characteristicId = characteristic.getUuid();
        this.kontaktDeviceCharacteristic = KontaktDeviceCharacteristic.fromUuid(characteristic.getUuid());
        SDKPreconditions.checkNotNull(this.kontaktDeviceCharacteristic, "Unknown characteristic with ID: " + characteristicId);
        this.name = this.kontaktDeviceCharacteristic.toString();
        this.characteristic = characteristic;
    }

    public UUID getUuid() {
        return this.characteristic.getUuid();
    }

    public boolean addDescriptor(BluetoothGattDescriptor descriptor) {
        return this.characteristic.addDescriptor(descriptor);
    }

    public BluetoothGattService getService() {
        return this.characteristic.getService();
    }

    public void setWriteType(int writeType) {
        this.characteristic.setWriteType(writeType);
    }

    public List<BluetoothGattDescriptor> getDescriptors() {
        return this.characteristic.getDescriptors();
    }

    public BluetoothGattDescriptor getDescriptor(UUID uuid) {
        return this.characteristic.getDescriptor(uuid);
    }

    public Integer getIntValue(int formatType, int offset) {
        return this.characteristic.getIntValue(formatType, offset);
    }

    public Float getFloatValue(int formatType, int offset) {
        return this.characteristic.getFloatValue(formatType, offset);
    }

    public String getStringValue(int offset) {
        return this.characteristic.getStringValue(offset);
    }

    public boolean setValue(int value, int formatType, int offset) {
        return this.characteristic.setValue(value, formatType, offset);
    }

    public boolean setValue(int mantissa, int exponent, int formatType, int offset) {
        return this.characteristic.setValue(mantissa, exponent, formatType, offset);
    }

    @TargetApi(value=18)
    public UUID getId() {
        return this.characteristic.getUuid();
    }

    public String getName() {
        return this.name;
    }

    @TargetApi(value=18)
    public boolean isWritable() {
        return (this.getProperties() & 0xC) != 0;
    }

    @TargetApi(value=18)
    public boolean isReadable() {
        return (this.getProperties() & 2) != 0;
    }

    @TargetApi(value=18)
    public boolean isNotifiable() {
        return (this.getProperties() & 0x10) != 0;
    }

    public void setValue(int value) {
        this.setValue(ByteBuffer.allocate(4).putInt(value).array());
    }

    public boolean setValue(String value) {
        return this.setValue(value.getBytes());
    }

    public boolean setValue(long value) {
        return this.setValue(ByteBuffer.allocate(4).putLong(value).array());
    }

    @TargetApi(value=18)
    public boolean setValue(byte[] value) {
        return this.characteristic.setValue(value);
    }

    @TargetApi(value=18)
    public byte[] getValue() {
        return this.characteristic.getValue();
    }

    @TargetApi(value=18)
    public String getStringValue() {
        byte[] value = this.characteristic.getValue();
        return value != null ? new String(value) : "";
    }

    @TargetApi(value=18)
    public String getHexStringValue() {
        byte[] value = this.characteristic.getValue();
        StringBuilder hexStringBuilder = new StringBuilder();
        for (int i = 0; i < value.length; ++i) {
            hexStringBuilder.append(Integer.toHexString(value[i] & 0xFF));
        }
        return hexStringBuilder.toString();
    }

    @TargetApi(value=18)
    public UUID getUUIDValue() {
        return ConversionUtils.toUUID(this.characteristic.getValue());
    }

    @TargetApi(value=18)
    public int getIntValue() {
        return ConversionUtils.asInt(this.characteristic.getValue());
    }

    public long getLongValue() {
        Integer value = this.getIntValue();
        return value.longValue();
    }

    @TargetApi(value=18)
    public int getPermissions() {
        return this.characteristic.getPermissions();
    }

    @TargetApi(value=18)
    public int getWriteType() {
        return this.characteristic.getWriteType();
    }

    @TargetApi(value=18)
    public int getProperties() {
        return this.characteristic.getProperties();
    }

    @TargetApi(value=18)
    public int getInstanceId() {
        return this.characteristic.getInstanceId();
    }

    public KontaktDeviceCharacteristic getKontaktDeviceCharacteristic() {
        return this.kontaktDeviceCharacteristic;
    }
}

