/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.service;

import android.annotation.TargetApi;
import com.kontakt.sdk.android.ble.cache.FutureShufflesCache;
import com.kontakt.sdk.android.ble.configuration.ForceScanConfiguration;
import com.kontakt.sdk.android.ble.configuration.ScanContext;
import com.kontakt.sdk.android.ble.monitoring.IEventCollector;
import com.kontakt.sdk.android.ble.service.BleScanCallback;
import com.kontakt.sdk.android.ble.service.ForceScanScheduler;
import com.kontakt.sdk.android.ble.service.MonitorCallback;
import com.kontakt.sdk.android.ble.service.Runners;
import com.kontakt.sdk.android.ble.service.ScanCompat;
import com.kontakt.sdk.android.ble.service.ScanConfiguration;
import com.kontakt.sdk.android.ble.service.ScanController;

@TargetApi(value=18)
final class ScanCompatJB
extends ScanCompat {
    ScanCompatJB() {
    }

    @Override
    public ScanConfiguration createScanConfiguration(ScanContext scanContext, FutureShufflesCache cache, IEventCollector eventCollector) {
        MonitorCallback scanCallback = MonitorCallback.create(scanContext, cache, eventCollector);
        return new ScanCompat.AbstractScanConfiguration(scanContext, (BleScanCallback)scanCallback){};
    }

    @Override
    public ScanController createScanController(ScanConfiguration configuration, ForceScanScheduler forceScanScheduler) {
        return new ScanController.Builder().setScanActiveRunner(Runners.newRunner(Runners.RunnerType.MONITOR_ACTIVE_RUNNER, configuration)).setScanPassiveRunner(Runners.newRunner(Runners.RunnerType.MONITOR_PASSIVE_RUNNER, configuration)).setScanPeriod(configuration.getScanContext().getScanPeriod()).setForceScanScheduler(forceScanScheduler).build();
    }

    @Override
    public ForceScanScheduler createForceScanScheduler(ScanConfiguration configuration) {
        ScanContext scanContext = configuration.getScanContext();
        if (scanContext.getForceScanConfiguration() == ForceScanConfiguration.DISABLED) {
            return ForceScanScheduler.DISABLED;
        }
        return new ForceScanScheduler(Runners.newRunner(Runners.RunnerType.FORCE_SCAN_RUNNER, configuration));
    }
}

