/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.security.property;

import com.kontakt.sdk.android.ble.security.property.AbstractProperty;
import com.kontakt.sdk.android.ble.security.property.PropertyID;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;

public class UInt32Property
extends AbstractProperty<Integer> {
    private static final int UINT32_SIZE = 4;
    private int value;

    public UInt32Property(PropertyID id, int value) {
        super(id);
        this.value = value;
    }

    public UInt32Property(PropertyID id, byte[] value) {
        super(id);
        SDKPreconditions.checkArgument(value.length == 4);
        this.value = ByteBuffer.wrap(value).order(ByteOrder.LITTLE_ENDIAN).getInt();
    }

    @Override
    public byte[] getBytes() {
        return ByteBuffer.allocate(4).order(ByteOrder.LITTLE_ENDIAN).putInt(this.value).array();
    }

    @Override
    public byte getSize() {
        return 4;
    }

    @Override
    public Integer getValue() {
        return this.value;
    }
}

