/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.monitoring;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.kontakt.sdk.android.cloud.adapter.TelemetryCollectEventTypeAdapter;
import com.kontakt.sdk.android.cloud.api.service.TelemetryCollectEventService;
import com.kontakt.sdk.android.cloud.util.ErrorUtils;
import com.kontakt.sdk.android.common.model.TelemetryCollectEvent;
import com.kontakt.sdk.android.common.util.ApiUtils;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.IOException;
import java.util.List;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.gson.GsonConverterFactory;
import retrofit2.converter.scalars.ScalarsConverterFactory;

class EventCollectorClient {
    private final TelemetryCollectEventService eventsService;

    EventCollectorClient(String apiKey, String apiUrl, int apiVersion) {
        SDKPreconditions.checkNotNullOrEmpty(apiKey, "EventCollectorClient - empty api key.");
        SDKPreconditions.checkNotNullOrEmpty(apiUrl, "EventCollectorClient - empty api url.");
        Retrofit retrofit = this.buildRetrofit(apiUrl, this.buildHttpClient(apiKey, apiVersion));
        this.eventsService = (TelemetryCollectEventService)retrofit.create(TelemetryCollectEventService.class);
        ErrorUtils.initialize(retrofit);
    }

    private OkHttpClient buildHttpClient(String apiKey, int apiVersion) {
        OkHttpClient.Builder builder = new OkHttpClient.Builder();
        builder.addInterceptor(ApiUtils.commonHeadersInterceptor(apiKey, apiVersion));
        builder.addInterceptor(ApiUtils.loggingInterceptor());
        builder.addInterceptor(this.applicationJsonHeaderInterceptor());
        return builder.build();
    }

    private Interceptor applicationJsonHeaderInterceptor() {
        return new Interceptor(){

            public Response intercept(Interceptor.Chain chain) throws IOException {
                Request original = chain.request();
                Request.Builder requestBuilder = original.newBuilder().header("Content-Type", "application/json").method(original.method(), original.body());
                Request request = requestBuilder.build();
                return chain.proceed(request);
            }
        };
    }

    private Retrofit buildRetrofit(String apiBaseUrl, OkHttpClient okHttpClient) {
        Retrofit.Builder retrofitBuilder = new Retrofit.Builder().baseUrl(apiBaseUrl).addConverterFactory((Converter.Factory)ScalarsConverterFactory.create()).addConverterFactory((Converter.Factory)GsonConverterFactory.create((Gson)this.gson())).client(okHttpClient);
        return retrofitBuilder.build();
    }

    private Gson gson() {
        return new GsonBuilder().registerTypeAdapter(TelemetryCollectEvent.class, (Object)new TelemetryCollectEventTypeAdapter()).setPrettyPrinting().create();
    }

    void collect(List<TelemetryCollectEvent> collectEventList) throws IOException {
        this.eventsService.collectTelemetry(collectEventList).execute();
    }
}

