/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.discovery.eddystone;

import android.bluetooth.BluetoothDevice;
import android.util.SparseIntArray;
import com.kontakt.sdk.android.ble.configuration.ScanContext;
import com.kontakt.sdk.android.ble.device.EddystoneDevice;
import com.kontakt.sdk.android.ble.discovery.DiscoveryUtils;
import com.kontakt.sdk.android.ble.discovery.FrameDataType;
import com.kontakt.sdk.android.ble.discovery.Parser;
import com.kontakt.sdk.android.ble.discovery.ScanResponse;
import com.kontakt.sdk.android.ble.discovery.eddystone.EIDResolver;
import com.kontakt.sdk.android.ble.discovery.eddystone.ETLMResolver;
import com.kontakt.sdk.android.ble.discovery.eddystone.InstanceIdResolver;
import com.kontakt.sdk.android.ble.discovery.eddystone.NamespaceIdResolver;
import com.kontakt.sdk.android.ble.discovery.eddystone.TLMResolver;
import com.kontakt.sdk.android.ble.discovery.eddystone.URLResolver;
import com.kontakt.sdk.android.ble.spec.EddystoneFrameType;
import com.kontakt.sdk.android.ble.spec.Telemetry;
import com.kontakt.sdk.android.common.Proximity;
import com.kontakt.sdk.android.common.log.Logger;
import com.kontakt.sdk.android.common.profile.DeviceProfile;
import com.kontakt.sdk.android.common.profile.IEddystoneDevice;
import com.kontakt.sdk.android.common.profile.IEddystoneNamespace;
import com.kontakt.sdk.android.common.util.ConversionUtils;
import com.kontakt.sdk.android.common.util.LimitedLinkedHashMap;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public final class EddystoneParser
extends Parser<EddystoneDevice> {
    private static final int HEADER_LENGTH = 12;
    private static final int HEADER_BLE_FLAGS_LENGTH_OF_FLAGS_BLOCK = 2;
    private static final int HEADER_BLE_FLAGS_PDU_DATA_TYPE = 1;
    private static final int HEADER_BLE_FLAGS_DATA = 6;
    private static final int HEADER_SERVICE_UUID_LENGTH_OF_SERVICE_UUID_BLOCK = 3;
    private static final int HEADER_SERVICE_UUID_PDU_DATA_TYPE = 3;
    private static final byte HEADER_SERVICE_UUID_HIGH_ORDER_VALUE = -86;
    private static final byte HEADER_SERVICE_UUID_LOW_ORDER_VALUE = -2;
    private static final int EDDYSTONE_PACKET_TX_POWER_INDEX = 3;
    private static final int EDDYSTONE_ENCRYPTED_TLM_VERSION = 1;
    private static final NamespaceIdResolver NAMESPACE_ID_RESOLVER = new NamespaceIdResolver(4);
    private static final InstanceIdResolver INSTANCE_ID_RESOLVER = new InstanceIdResolver(14);
    private static final URLResolver URL_RESOLVER = new URLResolver();
    private static final TLMResolver TLM_RESOLVER = new TLMResolver();
    private static final ETLMResolver ETLM_RESOLVER = new ETLMResolver();
    private static final EIDResolver EID_RESOLVER = new EIDResolver();
    private static byte[] EDDYSTONE_SPECIFIC_HEADER = new byte[]{2, 1, 6, 3, 3, -86, -2};
    private final Map<String, ScanResponse> scanResponseCache = new LimitedLinkedHashMap<String, ScanResponse>(50);
    private final SparseIntArray txPowerCache = new SparseIntArray();
    private final Set<IEddystoneNamespace> namespaces;
    private final Collection<EddystoneFrameType> triggerFrameTypes;

    public EddystoneParser(ScanContext scanContext) {
        super(scanContext);
        this.namespaces = scanContext.getEddystoneNamespaces();
        this.triggerFrameTypes = scanContext.getEddystoneFrameTypes();
    }

    boolean isValidEddystoneFrame(byte[] scanRecord) {
        return scanRecord != null && scanRecord.length >= 12 && ConversionUtils.doesArrayBeginWith(scanRecord, EDDYSTONE_SPECIFIC_HEADER) && scanRecord[9] == -86 && scanRecord[10] == -2;
    }

    public boolean parseFrame(EddystoneFrameType frameType, String deviceAddress, byte[] scanRecord) {
        this.frameData.clear();
        this.extractFrameData(scanRecord, this.frameData);
        byte[] packetFrame = (byte[])this.frameData.get((Object)FrameDataType.EDDYSTONE_PACKET_SERVICE_DATA);
        if (packetFrame == null) {
            return false;
        }
        this.saveScanResponse(deviceAddress);
        switch (frameType) {
            case UID: {
                return this.saveUID(deviceAddress, packetFrame);
            }
            case URL: {
                return this.saveURL(deviceAddress, packetFrame);
            }
            case TLM: {
                return this.isTlmPacketEncrypted(packetFrame) ? this.saveETLM(deviceAddress, packetFrame) : this.saveTLM(deviceAddress, packetFrame);
            }
            case EID: {
                return this.saveEID(deviceAddress, packetFrame);
            }
        }
        Logger.e("Unknown Eddystone packetFrame type parsed for device with address: " + deviceAddress);
        return false;
    }

    private void saveScanResponse(String deviceAddress) {
        boolean isScanResponsePresent = this.isScanResponsePresent();
        byte[] serviceData = (byte[])this.frameData.get((Object)FrameDataType.SCAN_RESPONSE_SERVICE_DATA);
        if (!this.scanResponseCache.containsKey(deviceAddress)) {
            ScanResponse scanResponse = isScanResponsePresent ? ScanResponse.fromScanResponseBytes(serviceData) : ScanResponse.UNKNOWN;
            this.scanResponseCache.put(deviceAddress, scanResponse);
        } else if (this.scanResponseCache.get(deviceAddress).isUnknown() && isScanResponsePresent) {
            this.scanResponseCache.put(deviceAddress, ScanResponse.fromScanResponseBytes(serviceData));
        }
    }

    private boolean saveUID(String deviceAddress, byte[] frame) {
        String namespace = NAMESPACE_ID_RESOLVER.parse(frame);
        String instanceId = INSTANCE_ID_RESOLVER.parse(frame);
        if (namespace == null || instanceId == null) {
            return false;
        }
        this.updateTxPower(deviceAddress, frame[3]);
        EddystoneDevice device = this.getCachedEddystoneDevice(deviceAddress);
        if (device == null) {
            device = new EddystoneDevice.Builder().namespace(namespace).instanceId(instanceId).build();
            this.putEddystoneDeviceInCache(deviceAddress, device);
        } else {
            device.setNamespace(namespace);
            device.setInstanceId(instanceId);
        }
        return true;
    }

    private boolean saveURL(String deviceAddress, byte[] frame) {
        String url = URL_RESOLVER.parse(frame);
        if (url == null) {
            return false;
        }
        this.updateTxPower(deviceAddress, frame[3]);
        EddystoneDevice device = this.getCachedEddystoneDevice(deviceAddress);
        if (device == null) {
            device = new EddystoneDevice.Builder().url(url).build();
            this.putEddystoneDeviceInCache(deviceAddress, device);
        } else {
            device.setUrl(url);
        }
        return true;
    }

    private boolean saveTLM(String deviceAddress, byte[] frame) {
        Telemetry telemetry = TLM_RESOLVER.parse(frame);
        if (telemetry == null) {
            return false;
        }
        EddystoneDevice device = this.getCachedEddystoneDevice(deviceAddress);
        if (device == null) {
            device = new EddystoneDevice.Builder().telemetry(telemetry).build();
            this.putEddystoneDeviceInCache(deviceAddress, device);
        } else {
            device.setTelemetry(telemetry);
        }
        return true;
    }

    private boolean saveETLM(String deviceAddress, byte[] frame) {
        String etlm = ETLM_RESOLVER.parse(frame);
        if (etlm == null) {
            return false;
        }
        EddystoneDevice device = this.getCachedEddystoneDevice(deviceAddress);
        if (device == null) {
            device = new EddystoneDevice.Builder().encryptedTelemetry(etlm).build();
            this.putEddystoneDeviceInCache(deviceAddress, device);
        } else {
            device.setEncryptedTelemetry(etlm);
        }
        return true;
    }

    private boolean saveEID(String deviceAddress, byte[] frame) {
        String eid = EID_RESOLVER.parse(frame);
        if (eid == null) {
            return false;
        }
        this.updateTxPower(deviceAddress, frame[3]);
        EddystoneDevice device = this.getCachedEddystoneDevice(deviceAddress);
        if (device == null) {
            device = new EddystoneDevice.Builder().eid(eid).build();
            this.putEddystoneDeviceInCache(deviceAddress, device);
        } else {
            device.setEid(eid);
        }
        return true;
    }

    IEddystoneDevice getEddystoneDevice(BluetoothDevice bluetoothDevice, int rssi) {
        String deviceAddress = bluetoothDevice.getAddress();
        int txPower = this.getTxPower(deviceAddress.hashCode());
        int calculatedRssi = this.rssiCalculator.calculateRssi(deviceAddress.hashCode(), rssi);
        double distance = DiscoveryUtils.calculateDistance(txPower, calculatedRssi, DeviceProfile.EDDYSTONE);
        Proximity proximity = Proximity.fromDistance(distance);
        String name = bluetoothDevice.getName();
        ScanResponse scanResponse = this.getScanResponse(deviceAddress);
        EddystoneDevice cachedEddystoneDevice = this.getCachedEddystoneDevice(deviceAddress);
        EddystoneDevice device = new EddystoneDevice.Builder(cachedEddystoneDevice).address(deviceAddress).name(name).uniqueId(scanResponse.getUniqueId()).firmwareRevision(scanResponse.getFirmwareVersion()).batteryPower(scanResponse.getBatteryPower()).shuffled(this.isShuffled(scanResponse, this.getNamespaceForDevice(deviceAddress))).txPower(txPower).distance(distance).proximity(proximity).rssi(calculatedRssi).timestamp(System.currentTimeMillis()).build();
        this.putEddystoneDeviceInCache(deviceAddress, device);
        return device;
    }

    private boolean isShuffled(ScanResponse scanResponse, String namespace) {
        return scanResponse.isUnknown() ? this.isDefinedSecureNamespace(namespace) : scanResponse.isShuffled();
    }

    private boolean isDefinedSecureNamespace(String namespace) {
        if (namespace == null) {
            return false;
        }
        for (IEddystoneNamespace definedNamespace : this.namespaces) {
            if (definedNamespace.getSecureNamespace() == null || !namespace.equalsIgnoreCase(definedNamespace.getSecureNamespace())) continue;
            return true;
        }
        return false;
    }

    private String getNamespaceForDevice(String deviceAddress) {
        return this.getCachedEddystoneDevice(deviceAddress).getNamespace();
    }

    boolean areTriggerFramesParsed(String deviceAddress) {
        boolean isEIDNotCached;
        boolean isTLMNotCached;
        boolean isURLNotCached;
        boolean isUIDNotCached;
        if (this.triggerFrameTypes.isEmpty()) {
            return true;
        }
        EddystoneDevice eddystone = this.getCachedEddystoneDevice(deviceAddress);
        boolean bl = isUIDNotCached = !this.hasFrame(eddystone, EddystoneFrameType.UID);
        if (this.triggerFrameTypes.contains((Object)EddystoneFrameType.UID) && isUIDNotCached) {
            return false;
        }
        boolean bl2 = isURLNotCached = !this.hasFrame(eddystone, EddystoneFrameType.URL);
        if (this.triggerFrameTypes.contains((Object)EddystoneFrameType.URL) && isURLNotCached) {
            return false;
        }
        boolean bl3 = isTLMNotCached = !this.hasFrame(eddystone, EddystoneFrameType.TLM);
        if (this.triggerFrameTypes.contains((Object)EddystoneFrameType.TLM) && isTLMNotCached) {
            return false;
        }
        boolean bl4 = isEIDNotCached = !this.hasFrame(eddystone, EddystoneFrameType.EID);
        return !this.triggerFrameTypes.contains((Object)EddystoneFrameType.EID) || !isEIDNotCached;
    }

    private ScanResponse getScanResponse(String deviceAddress) {
        return this.scanResponseCache.get(deviceAddress);
    }

    int getTxPowerCacheSize() {
        return this.txPowerCache.size();
    }

    private int getTxPower(int deviceAddressHashCode) {
        return this.txPowerCache.get(deviceAddressHashCode);
    }

    private void putEddystoneDeviceInCache(String deviceAddress, EddystoneDevice device) {
        int hashCode = this.hashCodeBuilder.append(deviceAddress).build();
        this.devicesCache.put(hashCode, device);
    }

    EddystoneDevice getCachedEddystoneDevice(String deviceAddress) {
        int hashCode = this.hashCodeBuilder.append(deviceAddress).build();
        return (EddystoneDevice)this.devicesCache.get(hashCode);
    }

    private void updateTxPower(String deviceAddress, int txPower) {
        this.txPowerCache.put(deviceAddress.hashCode(), txPower);
    }

    boolean hasFrame(IEddystoneDevice eddystone, EddystoneFrameType frameType) {
        if (eddystone == null || frameType == null) {
            return false;
        }
        switch (frameType) {
            case UID: {
                return eddystone.getNamespace() != null && eddystone.getInstanceId() != null;
            }
            case URL: {
                return eddystone.getUrl() != null;
            }
            case TLM: {
                return eddystone.getTelemetry() != null || eddystone.getEncryptedTelemetry() != null;
            }
            case EID: {
                return eddystone.getEid() != null;
            }
        }
        return false;
    }

    private boolean isScanResponsePresent() {
        byte[] serviceData = (byte[])this.frameData.get((Object)FrameDataType.SCAN_RESPONSE_SERVICE_DATA);
        return serviceData != null && ScanResponse.isValidKontaktScanResponse(serviceData);
    }

    private boolean isTlmPacketEncrypted(byte[] tlmPacketFrame) {
        return tlmPacketFrame[3] == 1;
    }

    @Override
    protected void disable() {
        if (this.isEnabled) {
            this.isEnabled = false;
            this.devicesCache.clear();
            this.rssiCalculator.clear();
            this.scanResponseCache.clear();
            this.txPowerCache.clear();
        }
    }
}

