/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.common.model;

import android.os.Parcel;
import android.os.Parcelable;
import com.kontakt.sdk.android.common.model.Coordinates;
import java.io.Serializable;
import java.util.UUID;

public class Receiver
implements Parcelable {
    public static final Parcelable.Creator<Receiver> CREATOR = new Parcelable.Creator<Receiver>(){

        public Receiver createFromParcel(Parcel source) {
            return new Receiver(source);
        }

        public Receiver[] newArray(int size) {
            return new Receiver[size];
        }
    };
    private final String deviceUniqueId;
    private final UUID id;
    private final UUID placeId;
    private final Coordinates coordinates;

    Receiver() {
        this(new Builder());
    }

    Receiver(Builder builder) {
        this.deviceUniqueId = builder.deviceUniqueId;
        this.id = builder.id;
        this.placeId = builder.placeId;
        this.coordinates = builder.coordinates;
    }

    protected Receiver(Parcel in) {
        this.deviceUniqueId = in.readString();
        this.id = (UUID)in.readSerializable();
        this.placeId = (UUID)in.readSerializable();
        this.coordinates = (Coordinates)in.readParcelable(Coordinates.class.getClassLoader());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Receiver receiver = (Receiver)o;
        if (this.deviceUniqueId != null ? !this.deviceUniqueId.equals(receiver.deviceUniqueId) : receiver.deviceUniqueId != null) {
            return false;
        }
        if (this.id != null ? !this.id.equals(receiver.id) : receiver.id != null) {
            return false;
        }
        if (this.placeId != null ? !this.placeId.equals(receiver.placeId) : receiver.placeId != null) {
            return false;
        }
        return this.coordinates != null ? this.coordinates.equals(receiver.coordinates) : receiver.coordinates == null;
    }

    public int hashCode() {
        int result = this.deviceUniqueId != null ? this.deviceUniqueId.hashCode() : 0;
        result = 31 * result + (this.id != null ? this.id.hashCode() : 0);
        result = 31 * result + (this.placeId != null ? this.placeId.hashCode() : 0);
        result = 31 * result + (this.coordinates != null ? this.coordinates.hashCode() : 0);
        return result;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.deviceUniqueId);
        dest.writeSerializable((Serializable)this.id);
        dest.writeSerializable((Serializable)this.placeId);
        dest.writeParcelable((Parcelable)this.coordinates, flags);
    }

    public String getDeviceUniqueId() {
        return this.deviceUniqueId;
    }

    public UUID getId() {
        return this.id;
    }

    public UUID getPlaceId() {
        return this.placeId;
    }

    public Coordinates getCoordinates() {
        return this.coordinates;
    }

    public static class Builder {
        String deviceUniqueId;
        UUID id;
        UUID placeId;
        Coordinates coordinates;

        public Builder deviceUniqueId(String deviceUniqueId) {
            this.deviceUniqueId = deviceUniqueId;
            return this;
        }

        public Builder id(UUID id) {
            this.id = id;
            return this;
        }

        public Builder placeId(UUID placeId) {
            this.placeId = placeId;
            return this;
        }

        public Builder coordinates(Coordinates coordinates) {
            this.coordinates = coordinates;
            return this;
        }

        public Receiver build() {
            return new Receiver(this);
        }
    }
}

