/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.venues;

import android.util.Base64;
import com.kontakt.sdk.android.cloud.api.executor.RequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.VenuesService;
import com.kontakt.sdk.android.cloud.exception.KontaktCloudException;
import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.common.model.Venue;
import com.kontakt.sdk.android.common.util.ConversionUtils;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import retrofit2.Call;

public class UpdateVenueRequestExecutor
extends RequestExecutor<String> {
    private final VenuesService venuesService;
    private final UUID id;
    private Venue venue;
    private String imageFile;

    public UpdateVenueRequestExecutor(VenuesService venuesService, UUID id) {
        this.venuesService = venuesService;
        this.id = id;
    }

    public UpdateVenueRequestExecutor with(Venue venue) {
        SDKPreconditions.checkNotNull(venue, "venue cannot be null");
        this.venue = venue;
        return this;
    }

    public UpdateVenueRequestExecutor withImageFile(File file) throws IOException {
        SDKPreconditions.checkNotNull(file, "file is null");
        SDKPreconditions.checkState(file.exists(), "file does not exist");
        byte[] bytes = ConversionUtils.convert(file);
        this.imageFile = Base64.encodeToString((byte[])bytes, (int)0);
        return this;
    }

    public UpdateVenueRequestExecutor withImageFile(byte[] bytes) throws IOException {
        SDKPreconditions.checkNotNull(bytes, "bytes cannot be null");
        this.imageFile = Base64.encodeToString((byte[])bytes, (int)0);
        return this;
    }

    @Override
    public String execute() throws IOException, KontaktCloudException {
        this.checkPreconditions();
        return (String)super.execute();
    }

    @Override
    public void execute(CloudCallback<String> callback) {
        this.checkPreconditions();
        super.execute(callback);
    }

    @Override
    protected Call<String> prepareCall() {
        return this.venuesService.updateVenue(this.params());
    }

    private void checkPreconditions() {
        SDKPreconditions.checkState(this.venue != null, "cannot update venue - specify venue data to update");
    }

    @Override
    protected Map<String, String> params() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("venueId", this.id.toString());
        params.put("name", this.venue.getName());
        params.put("description", this.venue.getDescription());
        if (this.imageFile != null) {
            params.put("file", this.imageFile);
        }
        if (this.venue.getLatitude() != null) {
            params.put("lat", this.venue.getLatitude());
        }
        if (this.venue.getLongitude() != null) {
            params.put("lng", this.venue.getLongitude());
        }
        return params;
    }
}

