/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.cloud.api.executor.receivers;

import com.kontakt.sdk.android.cloud.api.executor.RequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.ReceiversService;
import com.kontakt.sdk.android.cloud.exception.KontaktCloudException;
import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.common.model.Receiver;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import retrofit2.Call;

public class CreateReceiverRequestExecutor
extends RequestExecutor<Receiver> {
    private final ReceiversService receiversService;
    private final Receiver receiver;

    public CreateReceiverRequestExecutor(ReceiversService receiversService, Receiver receiver) {
        this.receiversService = receiversService;
        this.receiver = receiver;
    }

    @Override
    public Receiver execute() throws IOException, KontaktCloudException {
        this.checkPreconditions();
        return (Receiver)super.execute();
    }

    @Override
    public void execute(CloudCallback<Receiver> callback) {
        this.checkPreconditions();
        super.execute(callback);
    }

    @Override
    protected Call<Receiver> prepareCall() {
        return this.receiversService.createReceiver(this.params());
    }

    private void checkPreconditions() {
        SDKPreconditions.checkState(this.receiver.getDeviceUniqueId() != null, "cannot create receiver - specify device unique ID");
        SDKPreconditions.checkState(this.receiver.getPlaceId() != null, "cannot create receiver - specify place ID");
        SDKPreconditions.checkState(this.receiver.getCoordinates() != null, "cannot create receiver - specify coordinates");
    }

    @Override
    protected Map<String, String> params() {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("uniqueId", this.receiver.getDeviceUniqueId());
        params.put("placeId", this.receiver.getPlaceId().toString());
        params.put("coordinates", this.receiver.getCoordinates().toString());
        return params;
    }
}

