/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.security.property;

import com.kontakt.sdk.android.ble.security.property.PropertyID;
import java.nio.ByteBuffer;
import java.util.Arrays;

public abstract class AbstractProperty<T> {
    private static final int PID_LENGTH_IN_BYTES = 2;
    private static final int VALUE_LENGTH_IN_BYTES = 1;
    private final PropertyID propertyID;

    protected AbstractProperty(PropertyID propertyID) {
        this.propertyID = propertyID;
    }

    public PropertyID getPropertyID() {
        return this.propertyID;
    }

    public byte[] getData() {
        byte[] value = this.getBytes();
        ByteBuffer buf = ByteBuffer.allocate(value.length + 2 + 1);
        buf.put((byte)(value.length + 2));
        buf.putShort(Short.reverseBytes(this.propertyID.getValue()));
        buf.put(value);
        return buf.array();
    }

    public abstract byte[] getBytes();

    public abstract byte getSize();

    public abstract T getValue();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AbstractProperty that = (AbstractProperty)o;
        if (this.propertyID != null ? !this.propertyID.equals(that.propertyID) : that.propertyID != null) {
            return false;
        }
        return Arrays.equals(this.getBytes(), that.getBytes());
    }

    public int hashCode() {
        int result = this.propertyID != null ? this.propertyID.hashCode() : 0;
        result = 31 * result + Arrays.hashCode(this.getBytes());
        return result;
    }
}

