/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.security.auth;

import com.kontakt.sdk.android.ble.security.EncryptedReadAllRequest;
import com.kontakt.sdk.android.cloud.KontaktCloud;
import com.kontakt.sdk.android.cloud.KontaktCloudFactory;
import com.kontakt.sdk.android.cloud.response.CloudCallback;
import com.kontakt.sdk.android.cloud.response.CloudError;
import com.kontakt.sdk.android.cloud.response.CloudHeaders;
import com.kontakt.sdk.android.cloud.response.paginated.Configs;
import com.kontakt.sdk.android.cloud.response.paginated.CredentialsList;
import com.kontakt.sdk.android.common.TimestampUtil;
import com.kontakt.sdk.android.common.model.Config;
import com.kontakt.sdk.android.common.model.Credentials;
import com.kontakt.sdk.android.common.util.SDKPreconditions;

public class AuthToken {
    private final String uniqueId;
    private final String password;
    private final String token;

    public static void obtain(String uniqueId, AuthTokenCallback callback) {
        AuthToken.obtain(uniqueId, KontaktCloudFactory.create(), callback);
    }

    public static void obtain(final String uniqueId, final KontaktCloud kontaktCloud, final AuthTokenCallback callback) {
        SDKPreconditions.checkNotNull(uniqueId, "Unique ID can't be null");
        SDKPreconditions.checkNotNull(kontaktCloud, "KontaktCloud can't be null");
        SDKPreconditions.checkNotNull(callback, "Callback can't be null");
        kontaktCloud.devices().credentials(uniqueId).execute(new CloudCallback<CredentialsList>(){

            @Override
            public void onSuccess(CredentialsList response, CloudHeaders headers) {
                final String password = ((Credentials)response.getContent().get(0)).getPassword();
                kontaktCloud.configs().readAll().withIds(uniqueId).execute(new CloudCallback<Configs>(){

                    @Override
                    public void onSuccess(Configs response, CloudHeaders headers) {
                        String token = ((Config)response.getContent().get(0)).getSecureRequest();
                        callback.onSuccess(new AuthToken(uniqueId, password, token));
                    }

                    @Override
                    public void onError(CloudError error) {
                        callback.onError(error.getMessage());
                    }
                });
            }

            @Override
            public void onError(CloudError error) {
                callback.onError(error.getMessage());
            }
        });
    }

    public static AuthToken obtain(String password) {
        SDKPreconditions.checkNotNull(password, "Password can't be null");
        int timestampToken = (int)TimestampUtil.currentTimeSeconds();
        EncryptedReadAllRequest readAllRequest = new EncryptedReadAllRequest(timestampToken, password);
        return new AuthToken("", password, readAllRequest.getBase64Data());
    }

    AuthToken(String uniqueId, String password, String token) {
        this.uniqueId = uniqueId;
        this.token = token;
        this.password = password;
    }

    public String getUniqueId() {
        return this.uniqueId;
    }

    public String getToken() {
        return this.token;
    }

    public String getPassword() {
        return this.password;
    }

    public static interface AuthTokenCallback {
        public void onSuccess(AuthToken var1);

        public void onError(String var1);
    }
}

