/*
 * Decompiled with CFR 0.152.
 */
package com.kontakt.sdk.android.ble.manager.internal;

import com.kontakt.sdk.android.ble.configuration.ScanContext;
import com.kontakt.sdk.android.ble.exception.ScanError;
import com.kontakt.sdk.android.ble.manager.internal.SpacesResolver;
import com.kontakt.sdk.android.cloud.KontaktCloud;
import com.kontakt.sdk.android.common.profile.IBeaconRegion;
import com.kontakt.sdk.android.common.profile.IEddystoneNamespace;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

class ShuffledSpacesManager {
    final List<SpacesResolver> resolvers = new ArrayList<SpacesResolver>();
    OnSpacesResolvedListener onSpacesResolvedListener = OnSpacesResolvedListener.NOOP_LISTENER;
    private ScanContext scanContext;
    private final SpacesResolver.ResolvingStatusListener resolvingStatusListener = new SpacesResolver.ResolvingStatusListener(){

        @Override
        public void onSuccess() {
            if (ShuffledSpacesManager.this.allResolversAreFinishedSuccessfully()) {
                Collection<IBeaconRegion> regions = ShuffledSpacesManager.this.resolvers.get(0).getResolvedSpaces();
                Collection<IEddystoneNamespace> namespaces = ShuffledSpacesManager.this.resolvers.get(1).getResolvedSpaces();
                ShuffledSpacesManager.this.resetFinishedStatus();
                ShuffledSpacesManager.this.onSpacesResolvedListener.onSpacesResolved(ShuffledSpacesManager.this.createScanContext(regions, namespaces));
            }
        }

        @Override
        public void onError(String message) {
            ShuffledSpacesManager.this.onSpacesResolvedListener.onError(new ScanError(message));
        }
    };

    ShuffledSpacesManager(KontaktCloud cloud) {
        SDKPreconditions.checkNotNull(cloud);
        this.resolvers.add(new SpacesResolver.RegionsResolver(cloud));
        this.resolvers.add(new SpacesResolver.NamespacesResolver(cloud));
    }

    ShuffledSpacesManager(KontaktCloud cloud, SpacesResolver ... resolvers) {
        SDKPreconditions.checkNotNull(cloud);
        Collections.addAll(this.resolvers, resolvers);
    }

    public void resolve(ScanContext scanContext, OnSpacesResolvedListener onSpacesResolvedListener) {
        this.scanContext = SDKPreconditions.checkNotNull(scanContext);
        this.onSpacesResolvedListener = SDKPreconditions.checkNotNull(onSpacesResolvedListener);
        for (SpacesResolver resolver : this.resolvers) {
            resolver.resolve(scanContext, this.resolvingStatusListener);
        }
    }

    void onDestroy() {
        this.clearCache();
        this.onSpacesResolvedListener = OnSpacesResolvedListener.NOOP_LISTENER;
    }

    void clearCache() {
        for (SpacesResolver resolver : this.resolvers) {
            resolver.clearCache();
        }
    }

    ScanContext createScanContext(Collection<IBeaconRegion> resolvedRegions, Collection<IEddystoneNamespace> resolvedNamespaces) {
        ScanContext.Builder newContext = new ScanContext.Builder(this.scanContext);
        if (!resolvedRegions.isEmpty()) {
            newContext.iBeaconRegions(resolvedRegions);
        }
        if (!resolvedNamespaces.isEmpty()) {
            newContext.eddystoneNamespaces(resolvedNamespaces);
        }
        return newContext.build();
    }

    void resetFinishedStatus() {
        for (SpacesResolver resolver : this.resolvers) {
            resolver.resetFinishedStatus();
        }
    }

    boolean allResolversAreFinishedSuccessfully() {
        for (SpacesResolver resolver : this.resolvers) {
            if (resolver.isFinishedSuccessfully()) continue;
            return false;
        }
        return true;
    }

    static interface OnSpacesResolvedListener {
        public static final OnSpacesResolvedListener NOOP_LISTENER = new OnSpacesResolvedListener(){

            @Override
            public void onSpacesResolved(ScanContext scanContext) {
            }

            @Override
            public void onError(ScanError error) {
            }
        };

        public void onSpacesResolved(ScanContext var1);

        public void onError(ScanError var1);
    }
}

