package com.kontakt.sdk.android.common.model;

import android.os.Parcel;
import android.os.Parcelable;
import java.util.UUID;

/**
 * Model class that represents JSON structure of Kontakt.io receiver. A Receiver acts as a BLE scanner device (Gateway).
 */
public class Receiver implements Parcelable {

  /**
   * Parcelable CREATOR constant.
   */
  public static final Parcelable.Creator<Receiver> CREATOR = new Parcelable.Creator<Receiver>() {
    @Override
    public Receiver createFromParcel(Parcel source) {
      return new Receiver(source);
    }

    @Override
    public Receiver[] newArray(int size) {
      return new Receiver[size];
    }
  };

  private final String deviceUniqueId;
  private final UUID id;
  private final UUID placeId;
  private final Coordinates coordinates;

  Receiver() {
    this(new Builder());
  }

  Receiver(Builder builder) {
    this.deviceUniqueId = builder.deviceUniqueId;
    this.id = builder.id;
    this.placeId = builder.placeId;
    this.coordinates = builder.coordinates;
  }

  protected Receiver(Parcel in) {
    this.deviceUniqueId = in.readString();
    this.id = (UUID) in.readSerializable();
    this.placeId = (UUID) in.readSerializable();
    this.coordinates = in.readParcelable(Coordinates.class.getClassLoader());
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) return true;
    if (o == null || getClass() != o.getClass()) return false;

    Receiver receiver = (Receiver) o;

    if (deviceUniqueId != null ? !deviceUniqueId.equals(receiver.deviceUniqueId) : receiver.deviceUniqueId != null) return false;
    if (id != null ? !id.equals(receiver.id) : receiver.id != null) return false;
    if (placeId != null ? !placeId.equals(receiver.placeId) : receiver.placeId != null) return false;
    return coordinates != null ? coordinates.equals(receiver.coordinates) : receiver.coordinates == null;
  }

  @Override
  public int hashCode() {
    int result = deviceUniqueId != null ? deviceUniqueId.hashCode() : 0;
    result = 31 * result + (id != null ? id.hashCode() : 0);
    result = 31 * result + (placeId != null ? placeId.hashCode() : 0);
    result = 31 * result + (coordinates != null ? coordinates.hashCode() : 0);
    return result;
  }

  @Override
  public int describeContents() {
    return 0;
  }

  @Override
  public void writeToParcel(Parcel dest, int flags) {
    dest.writeString(this.deviceUniqueId);
    dest.writeSerializable(this.id);
    dest.writeSerializable(this.placeId);
    dest.writeParcelable(this.coordinates, flags);
  }

  public String getDeviceUniqueId() {
    return deviceUniqueId;
  }

  public UUID getId() {
    return id;
  }

  public UUID getPlaceId() {
    return placeId;
  }

  public Coordinates getCoordinates() {
    return coordinates;
  }

  public static class Builder {
    String deviceUniqueId;
    UUID id;
    UUID placeId;
    Coordinates coordinates;

    public Builder deviceUniqueId(final String deviceUniqueId) {
      this.deviceUniqueId = deviceUniqueId;
      return this;
    }

    public Builder id(final UUID id) {
      this.id = id;
      return this;
    }

    public Builder placeId(final UUID placeId) {
      this.placeId = placeId;
      return this;
    }

    public Builder coordinates(final Coordinates coordinates) {
      this.coordinates = coordinates;
      return this;
    }

    public Receiver build() {
      return new Receiver(this);
    }
  }
}
