package com.kontakt.sdk.android.cloud.response;

import com.kontakt.sdk.android.cloud.CloudConstants;
import com.kontakt.sdk.android.common.util.SDKPreconditions;
import java.util.HashMap;
import java.util.Map;

/**
 * A container for response headers retrieved from Kontakt.io Proximity REST API.
 */
public class CloudHeaders {

  private Map<String, String> headers = new HashMap<>();

  /**
   * Constructs new instance of {@code CloudHeaders} initialized with headers map.
   *
   * @param headers the headers map.
   * @return CloudHeaders instance
   */
  public static CloudHeaders of(final Map<String, String> headers) {
    SDKPreconditions.checkNotNull(headers, "headers cannot be null");
    return new CloudHeaders(headers);
  }

  private CloudHeaders(final Map<String, String> headers) {
    this.headers = headers;
  }

  /**
   * Returns all headers.
   *
   * @return the headers map.
   */
  public Map<String, String> all() {
    return headers;
  }

  /**
   * Returns the HTTP ETag.
   *
   * @return the entity tag header value.
   */
  public String eTag() {
    return headers.get(CloudConstants.MainHeaders.ETAG_RESPONSE);
  }
}
