package com.kontakt.sdk.android.cloud.api.executor.places;

import com.kontakt.sdk.android.cloud.CloudConstants;
import com.kontakt.sdk.android.cloud.api.PlacesApi;
import com.kontakt.sdk.android.cloud.api.executor.RequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.PlacesService;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import retrofit2.Call;

/**
 * Request executor provided by {@link PlacesApi}. Use this class if you want to delete
 * places through fluent API in chained fashion, for example:
 * <pre>
 *   <code>
 *   KontaktCloud kontaktCloud = KontaktCloudFactory.create();
 *   kontaktCloud.places().delete(ID).execute();
 *   </code>
 * </pre>
 */
public class DeletePlaceRequestExecutor extends RequestExecutor<String> {

  private final PlacesService placesService;
  private final UUID id;

  /**
   * Constructs request executor initialized with corresponding service class and place's identifier.
   *
   * @param placesService the places API service.
   * @param id the place's identifier.
   */
  public DeletePlaceRequestExecutor(PlacesService placesService, UUID id) {
    this.placesService = placesService;
    this.id = id;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Call<String> prepareCall() {
    return placesService.deletePlace(params());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Map<String, String> params() {
    final Map<String, String> params = new HashMap<>();
    params.put(CloudConstants.Places.PLACE_ID_PARAMETER, id.toString());
    return params;
  }
}
