package com.kontakt.sdk.android.cloud.api.executor.managers;

import com.kontakt.sdk.android.cloud.api.ManagersApi;
import com.kontakt.sdk.android.cloud.api.executor.RequestExecutor;
import com.kontakt.sdk.android.cloud.api.service.ManagersService;
import com.kontakt.sdk.android.common.model.Manager;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import retrofit2.Call;

/**
 * Request executor provided by {@link ManagersApi}. Use this class if you want to get
 * single manager through fluent API in chained fashion, for instance:
 * <pre>
 *   <code>
 *   KontaktCloud kontaktCloud = KontaktCloudFactory.create();
 *   Manager manager = kontaktCloud.managers().fetch(ID).execute();
 *   </code>
 * </pre>
 */
public class ManagerRequestExecutor extends RequestExecutor<Manager> {

  private final ManagersService managersService;

  private final UUID id;

  /**
   * Constructs request executor initialized with corresponding service class and manager's id.
   *
   * @param managersService the managers API service.
   * @param id the manager's unique identifier.
   */
  public ManagerRequestExecutor(final ManagersService managersService, final UUID id) {
    this.managersService = managersService;
    this.id = id;
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Call<Manager> prepareCall() {
    return managersService.getManager(id.toString());
  }

  /**
   * {@inheritDoc}
   */
  @Override
  protected Map<String, String> params() {
    return new HashMap<>();
  }
}
